/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.shipping;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;

@ApiModel(description="The weight.")
public class Weight {
    @SerializedName(value="unit")
    private UnitEnum unit = null;
    @SerializedName(value="value")
    private BigDecimal value = null;

    public Weight unit(UnitEnum unit) {
        this.unit = unit;
        return this;
    }

    @ApiModelProperty(required=true, value="The unit of measurement.")
    public UnitEnum getUnit() {
        return this.unit;
    }

    public void setUnit(UnitEnum unit) {
        this.unit = unit;
    }

    public Weight value(BigDecimal value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(required=true, value="The measurement value.")
    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Weight weight = (Weight)o;
        return Objects.equals((Object)this.unit, (Object)weight.unit) && Objects.equals(this.value, weight.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.unit, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Weight {\n");
        sb.append("    unit: ").append(this.toIndentedString((Object)this.unit)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum UnitEnum {
        G("g"),
        KG("kg"),
        OZ("oz"),
        LB("lb");

        private String value;

        private UnitEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static UnitEnum fromValue(String text) {
            for (UnitEnum b : UnitEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<UnitEnum> {
            public void write(JsonWriter jsonWriter, UnitEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public UnitEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return UnitEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

