/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.shipping;

import com.amazon.spapi.model.shipping.AcceptedRate;
import com.amazon.spapi.model.shipping.Address;
import com.amazon.spapi.model.shipping.ContainerList;
import com.amazon.spapi.model.shipping.Party;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The shipment related data.")
public class Shipment {
    @SerializedName(value="shipmentId")
    private String shipmentId = null;
    @SerializedName(value="clientReferenceId")
    private String clientReferenceId = null;
    @SerializedName(value="shipFrom")
    private Address shipFrom = null;
    @SerializedName(value="shipTo")
    private Address shipTo = null;
    @SerializedName(value="acceptedRate")
    private AcceptedRate acceptedRate = null;
    @SerializedName(value="shipper")
    private Party shipper = null;
    @SerializedName(value="containers")
    private ContainerList containers = null;

    public Shipment shipmentId(String shipmentId) {
        this.shipmentId = shipmentId;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getShipmentId() {
        return this.shipmentId;
    }

    public void setShipmentId(String shipmentId) {
        this.shipmentId = shipmentId;
    }

    public Shipment clientReferenceId(String clientReferenceId) {
        this.clientReferenceId = clientReferenceId;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getClientReferenceId() {
        return this.clientReferenceId;
    }

    public void setClientReferenceId(String clientReferenceId) {
        this.clientReferenceId = clientReferenceId;
    }

    public Shipment shipFrom(Address shipFrom) {
        this.shipFrom = shipFrom;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Address getShipFrom() {
        return this.shipFrom;
    }

    public void setShipFrom(Address shipFrom) {
        this.shipFrom = shipFrom;
    }

    public Shipment shipTo(Address shipTo) {
        this.shipTo = shipTo;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Address getShipTo() {
        return this.shipTo;
    }

    public void setShipTo(Address shipTo) {
        this.shipTo = shipTo;
    }

    public Shipment acceptedRate(AcceptedRate acceptedRate) {
        this.acceptedRate = acceptedRate;
        return this;
    }

    @ApiModelProperty(value="")
    public AcceptedRate getAcceptedRate() {
        return this.acceptedRate;
    }

    public void setAcceptedRate(AcceptedRate acceptedRate) {
        this.acceptedRate = acceptedRate;
    }

    public Shipment shipper(Party shipper) {
        this.shipper = shipper;
        return this;
    }

    @ApiModelProperty(value="")
    public Party getShipper() {
        return this.shipper;
    }

    public void setShipper(Party shipper) {
        this.shipper = shipper;
    }

    public Shipment containers(ContainerList containers) {
        this.containers = containers;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ContainerList getContainers() {
        return this.containers;
    }

    public void setContainers(ContainerList containers) {
        this.containers = containers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Shipment shipment = (Shipment)o;
        return Objects.equals(this.shipmentId, shipment.shipmentId) && Objects.equals(this.clientReferenceId, shipment.clientReferenceId) && Objects.equals(this.shipFrom, shipment.shipFrom) && Objects.equals(this.shipTo, shipment.shipTo) && Objects.equals(this.acceptedRate, shipment.acceptedRate) && Objects.equals(this.shipper, shipment.shipper) && Objects.equals(this.containers, shipment.containers);
    }

    public int hashCode() {
        return Objects.hash(this.shipmentId, this.clientReferenceId, this.shipFrom, this.shipTo, this.acceptedRate, this.shipper, this.containers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Shipment {\n");
        sb.append("    shipmentId: ").append(this.toIndentedString(this.shipmentId)).append("\n");
        sb.append("    clientReferenceId: ").append(this.toIndentedString(this.clientReferenceId)).append("\n");
        sb.append("    shipFrom: ").append(this.toIndentedString(this.shipFrom)).append("\n");
        sb.append("    shipTo: ").append(this.toIndentedString(this.shipTo)).append("\n");
        sb.append("    acceptedRate: ").append(this.toIndentedString(this.acceptedRate)).append("\n");
        sb.append("    shipper: ").append(this.toIndentedString(this.shipper)).append("\n");
        sb.append("    containers: ").append(this.toIndentedString(this.containers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

