/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.shipping;

import com.amazon.spapi.model.shipping.Address;
import com.amazon.spapi.model.shipping.ContainerList;
import com.amazon.spapi.model.shipping.LabelSpecification;
import com.amazon.spapi.model.shipping.ServiceType;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="The payload schema for the purchaseShipment operation.")
public class PurchaseShipmentRequest {
    @SerializedName(value="clientReferenceId")
    private String clientReferenceId = null;
    @SerializedName(value="shipTo")
    private Address shipTo = null;
    @SerializedName(value="shipFrom")
    private Address shipFrom = null;
    @SerializedName(value="shipDate")
    private OffsetDateTime shipDate = null;
    @SerializedName(value="serviceType")
    private ServiceType serviceType = null;
    @SerializedName(value="containers")
    private ContainerList containers = null;
    @SerializedName(value="labelSpecification")
    private LabelSpecification labelSpecification = null;

    public PurchaseShipmentRequest clientReferenceId(String clientReferenceId) {
        this.clientReferenceId = clientReferenceId;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getClientReferenceId() {
        return this.clientReferenceId;
    }

    public void setClientReferenceId(String clientReferenceId) {
        this.clientReferenceId = clientReferenceId;
    }

    public PurchaseShipmentRequest shipTo(Address shipTo) {
        this.shipTo = shipTo;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Address getShipTo() {
        return this.shipTo;
    }

    public void setShipTo(Address shipTo) {
        this.shipTo = shipTo;
    }

    public PurchaseShipmentRequest shipFrom(Address shipFrom) {
        this.shipFrom = shipFrom;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Address getShipFrom() {
        return this.shipFrom;
    }

    public void setShipFrom(Address shipFrom) {
        this.shipFrom = shipFrom;
    }

    public PurchaseShipmentRequest shipDate(OffsetDateTime shipDate) {
        this.shipDate = shipDate;
        return this;
    }

    @ApiModelProperty(value="The start date and time. This defaults to the current date and time.")
    public OffsetDateTime getShipDate() {
        return this.shipDate;
    }

    public void setShipDate(OffsetDateTime shipDate) {
        this.shipDate = shipDate;
    }

    public PurchaseShipmentRequest serviceType(ServiceType serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(ServiceType serviceType) {
        this.serviceType = serviceType;
    }

    public PurchaseShipmentRequest containers(ContainerList containers) {
        this.containers = containers;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ContainerList getContainers() {
        return this.containers;
    }

    public void setContainers(ContainerList containers) {
        this.containers = containers;
    }

    public PurchaseShipmentRequest labelSpecification(LabelSpecification labelSpecification) {
        this.labelSpecification = labelSpecification;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public LabelSpecification getLabelSpecification() {
        return this.labelSpecification;
    }

    public void setLabelSpecification(LabelSpecification labelSpecification) {
        this.labelSpecification = labelSpecification;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PurchaseShipmentRequest purchaseShipmentRequest = (PurchaseShipmentRequest)o;
        return Objects.equals(this.clientReferenceId, purchaseShipmentRequest.clientReferenceId) && Objects.equals(this.shipTo, purchaseShipmentRequest.shipTo) && Objects.equals(this.shipFrom, purchaseShipmentRequest.shipFrom) && Objects.equals(this.shipDate, purchaseShipmentRequest.shipDate) && Objects.equals((Object)this.serviceType, (Object)purchaseShipmentRequest.serviceType) && Objects.equals(this.containers, purchaseShipmentRequest.containers) && Objects.equals(this.labelSpecification, purchaseShipmentRequest.labelSpecification);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientReferenceId, this.shipTo, this.shipFrom, this.shipDate, this.serviceType, this.containers, this.labelSpecification});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PurchaseShipmentRequest {\n");
        sb.append("    clientReferenceId: ").append(this.toIndentedString(this.clientReferenceId)).append("\n");
        sb.append("    shipTo: ").append(this.toIndentedString(this.shipTo)).append("\n");
        sb.append("    shipFrom: ").append(this.toIndentedString(this.shipFrom)).append("\n");
        sb.append("    shipDate: ").append(this.toIndentedString(this.shipDate)).append("\n");
        sb.append("    serviceType: ").append(this.toIndentedString((Object)this.serviceType)).append("\n");
        sb.append("    containers: ").append(this.toIndentedString(this.containers)).append("\n");
        sb.append("    labelSpecification: ").append(this.toIndentedString(this.labelSpecification)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

