/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.shipping;

import com.amazon.spapi.model.shipping.Address;
import com.amazon.spapi.model.shipping.ContainerSpecificationList;
import com.amazon.spapi.model.shipping.ServiceTypeList;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="The payload schema for the getRates operation.")
public class GetRatesRequest {
    @SerializedName(value="shipTo")
    private Address shipTo = null;
    @SerializedName(value="shipFrom")
    private Address shipFrom = null;
    @SerializedName(value="serviceTypes")
    private ServiceTypeList serviceTypes = null;
    @SerializedName(value="shipDate")
    private OffsetDateTime shipDate = null;
    @SerializedName(value="containerSpecifications")
    private ContainerSpecificationList containerSpecifications = null;

    public GetRatesRequest shipTo(Address shipTo) {
        this.shipTo = shipTo;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Address getShipTo() {
        return this.shipTo;
    }

    public void setShipTo(Address shipTo) {
        this.shipTo = shipTo;
    }

    public GetRatesRequest shipFrom(Address shipFrom) {
        this.shipFrom = shipFrom;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Address getShipFrom() {
        return this.shipFrom;
    }

    public void setShipFrom(Address shipFrom) {
        this.shipFrom = shipFrom;
    }

    public GetRatesRequest serviceTypes(ServiceTypeList serviceTypes) {
        this.serviceTypes = serviceTypes;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ServiceTypeList getServiceTypes() {
        return this.serviceTypes;
    }

    public void setServiceTypes(ServiceTypeList serviceTypes) {
        this.serviceTypes = serviceTypes;
    }

    public GetRatesRequest shipDate(OffsetDateTime shipDate) {
        this.shipDate = shipDate;
        return this;
    }

    @ApiModelProperty(value="The start date and time. This defaults to the current date and time.")
    public OffsetDateTime getShipDate() {
        return this.shipDate;
    }

    public void setShipDate(OffsetDateTime shipDate) {
        this.shipDate = shipDate;
    }

    public GetRatesRequest containerSpecifications(ContainerSpecificationList containerSpecifications) {
        this.containerSpecifications = containerSpecifications;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ContainerSpecificationList getContainerSpecifications() {
        return this.containerSpecifications;
    }

    public void setContainerSpecifications(ContainerSpecificationList containerSpecifications) {
        this.containerSpecifications = containerSpecifications;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetRatesRequest getRatesRequest = (GetRatesRequest)o;
        return Objects.equals(this.shipTo, getRatesRequest.shipTo) && Objects.equals(this.shipFrom, getRatesRequest.shipFrom) && Objects.equals(this.serviceTypes, getRatesRequest.serviceTypes) && Objects.equals(this.shipDate, getRatesRequest.shipDate) && Objects.equals(this.containerSpecifications, getRatesRequest.containerSpecifications);
    }

    public int hashCode() {
        return Objects.hash(this.shipTo, this.shipFrom, this.serviceTypes, this.shipDate, this.containerSpecifications);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetRatesRequest {\n");
        sb.append("    shipTo: ").append(this.toIndentedString(this.shipTo)).append("\n");
        sb.append("    shipFrom: ").append(this.toIndentedString(this.shipFrom)).append("\n");
        sb.append("    serviceTypes: ").append(this.toIndentedString(this.serviceTypes)).append("\n");
        sb.append("    shipDate: ").append(this.toIndentedString(this.shipDate)).append("\n");
        sb.append("    containerSpecifications: ").append(this.toIndentedString(this.containerSpecifications)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

