/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.shipping;

import com.amazon.spapi.model.shipping.Dimensions;
import com.amazon.spapi.model.shipping.Weight;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Container specification for checking the service rate.")
public class ContainerSpecification {
    @SerializedName(value="dimensions")
    private Dimensions dimensions = null;
    @SerializedName(value="weight")
    private Weight weight = null;

    public ContainerSpecification dimensions(Dimensions dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    @ApiModelProperty(required=true, value="The length, width, and height of the container.")
    public Dimensions getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Dimensions dimensions) {
        this.dimensions = dimensions;
    }

    public ContainerSpecification weight(Weight weight) {
        this.weight = weight;
        return this;
    }

    @ApiModelProperty(required=true, value="The weight of the container.")
    public Weight getWeight() {
        return this.weight;
    }

    public void setWeight(Weight weight) {
        this.weight = weight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerSpecification containerSpecification = (ContainerSpecification)o;
        return Objects.equals(this.dimensions, containerSpecification.dimensions) && Objects.equals(this.weight, containerSpecification.weight);
    }

    public int hashCode() {
        return Objects.hash(this.dimensions, this.weight);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContainerSpecification {\n");
        sb.append("    dimensions: ").append(this.toIndentedString(this.dimensions)).append("\n");
        sb.append("    weight: ").append(this.toIndentedString(this.weight)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

