/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.shipping;

import com.amazon.spapi.model.shipping.ContainerItem;
import com.amazon.spapi.model.shipping.Currency;
import com.amazon.spapi.model.shipping.Dimensions;
import com.amazon.spapi.model.shipping.Weight;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Container in the shipment.")
public class Container {
    @SerializedName(value="containerType")
    private ContainerTypeEnum containerType = null;
    @SerializedName(value="containerReferenceId")
    private String containerReferenceId = null;
    @SerializedName(value="value")
    private Currency value = null;
    @SerializedName(value="dimensions")
    private Dimensions dimensions = null;
    @SerializedName(value="items")
    private List<ContainerItem> items = new ArrayList<ContainerItem>();
    @SerializedName(value="weight")
    private Weight weight = null;

    public Container containerType(ContainerTypeEnum containerType) {
        this.containerType = containerType;
        return this;
    }

    @ApiModelProperty(value="The type of physical container being used. (always 'PACKAGE')")
    public ContainerTypeEnum getContainerType() {
        return this.containerType;
    }

    public void setContainerType(ContainerTypeEnum containerType) {
        this.containerType = containerType;
    }

    public Container containerReferenceId(String containerReferenceId) {
        this.containerReferenceId = containerReferenceId;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getContainerReferenceId() {
        return this.containerReferenceId;
    }

    public void setContainerReferenceId(String containerReferenceId) {
        this.containerReferenceId = containerReferenceId;
    }

    public Container value(Currency value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(required=true, value="The total value of all items in the container.")
    public Currency getValue() {
        return this.value;
    }

    public void setValue(Currency value) {
        this.value = value;
    }

    public Container dimensions(Dimensions dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    @ApiModelProperty(required=true, value="The length, width, height, and weight of the container.")
    public Dimensions getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Dimensions dimensions) {
        this.dimensions = dimensions;
    }

    public Container items(List<ContainerItem> items) {
        this.items = items;
        return this;
    }

    public Container addItemsItem(ContainerItem itemsItem) {
        this.items.add(itemsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of the items in the container.")
    public List<ContainerItem> getItems() {
        return this.items;
    }

    public void setItems(List<ContainerItem> items) {
        this.items = items;
    }

    public Container weight(Weight weight) {
        this.weight = weight;
        return this;
    }

    @ApiModelProperty(required=true, value="The weight of the container.")
    public Weight getWeight() {
        return this.weight;
    }

    public void setWeight(Weight weight) {
        this.weight = weight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Container container = (Container)o;
        return Objects.equals((Object)this.containerType, (Object)container.containerType) && Objects.equals(this.containerReferenceId, container.containerReferenceId) && Objects.equals(this.value, container.value) && Objects.equals(this.dimensions, container.dimensions) && Objects.equals(this.items, container.items) && Objects.equals(this.weight, container.weight);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.containerType, this.containerReferenceId, this.value, this.dimensions, this.items, this.weight});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Container {\n");
        sb.append("    containerType: ").append(this.toIndentedString((Object)this.containerType)).append("\n");
        sb.append("    containerReferenceId: ").append(this.toIndentedString(this.containerReferenceId)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    dimensions: ").append(this.toIndentedString(this.dimensions)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    weight: ").append(this.toIndentedString(this.weight)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ContainerTypeEnum {
        PACKAGE("PACKAGE");

        private String value;

        private ContainerTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ContainerTypeEnum fromValue(String text) {
            for (ContainerTypeEnum b : ContainerTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ContainerTypeEnum> {
            public void write(JsonWriter jsonWriter, ContainerTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ContainerTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ContainerTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

