/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.shipmentinvoicing;

import com.amazon.spapi.model.shipmentinvoicing.Address;
import com.amazon.spapi.model.shipmentinvoicing.BuyerTaxInfo;
import com.amazon.spapi.model.shipmentinvoicing.MarketplaceTaxInfo;
import com.amazon.spapi.model.shipmentinvoicing.PaymentMethodDetailItemList;
import com.amazon.spapi.model.shipmentinvoicing.ShipmentItems;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="The information required by a selling partner to issue a shipment invoice.")
public class ShipmentDetail {
    @SerializedName(value="WarehouseId")
    private String warehouseId = null;
    @SerializedName(value="AmazonOrderId")
    private String amazonOrderId = null;
    @SerializedName(value="AmazonShipmentId")
    private String amazonShipmentId = null;
    @SerializedName(value="PurchaseDate")
    private OffsetDateTime purchaseDate = null;
    @SerializedName(value="ShippingAddress")
    private Address shippingAddress = null;
    @SerializedName(value="PaymentMethodDetails")
    private PaymentMethodDetailItemList paymentMethodDetails = null;
    @SerializedName(value="MarketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="SellerId")
    private String sellerId = null;
    @SerializedName(value="BuyerName")
    private String buyerName = null;
    @SerializedName(value="BuyerCounty")
    private String buyerCounty = null;
    @SerializedName(value="BuyerTaxInfo")
    private BuyerTaxInfo buyerTaxInfo = null;
    @SerializedName(value="MarketplaceTaxInfo")
    private MarketplaceTaxInfo marketplaceTaxInfo = null;
    @SerializedName(value="SellerDisplayName")
    private String sellerDisplayName = null;
    @SerializedName(value="ShipmentItems")
    private ShipmentItems shipmentItems = null;

    public ShipmentDetail warehouseId(String warehouseId) {
        this.warehouseId = warehouseId;
        return this;
    }

    @ApiModelProperty(value="The Amazon-defined identifier for the warehouse.")
    public String getWarehouseId() {
        return this.warehouseId;
    }

    public void setWarehouseId(String warehouseId) {
        this.warehouseId = warehouseId;
    }

    public ShipmentDetail amazonOrderId(String amazonOrderId) {
        this.amazonOrderId = amazonOrderId;
        return this;
    }

    @ApiModelProperty(value="The Amazon-defined identifier for the order.")
    public String getAmazonOrderId() {
        return this.amazonOrderId;
    }

    public void setAmazonOrderId(String amazonOrderId) {
        this.amazonOrderId = amazonOrderId;
    }

    public ShipmentDetail amazonShipmentId(String amazonShipmentId) {
        this.amazonShipmentId = amazonShipmentId;
        return this;
    }

    @ApiModelProperty(value="The Amazon-defined identifier for the shipment.")
    public String getAmazonShipmentId() {
        return this.amazonShipmentId;
    }

    public void setAmazonShipmentId(String amazonShipmentId) {
        this.amazonShipmentId = amazonShipmentId;
    }

    public ShipmentDetail purchaseDate(OffsetDateTime purchaseDate) {
        this.purchaseDate = purchaseDate;
        return this;
    }

    @ApiModelProperty(value="The date and time when the order was created.")
    public OffsetDateTime getPurchaseDate() {
        return this.purchaseDate;
    }

    public void setPurchaseDate(OffsetDateTime purchaseDate) {
        this.purchaseDate = purchaseDate;
    }

    public ShipmentDetail shippingAddress(Address shippingAddress) {
        this.shippingAddress = shippingAddress;
        return this;
    }

    @ApiModelProperty(value="")
    public Address getShippingAddress() {
        return this.shippingAddress;
    }

    public void setShippingAddress(Address shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    public ShipmentDetail paymentMethodDetails(PaymentMethodDetailItemList paymentMethodDetails) {
        this.paymentMethodDetails = paymentMethodDetails;
        return this;
    }

    @ApiModelProperty(value="")
    public PaymentMethodDetailItemList getPaymentMethodDetails() {
        return this.paymentMethodDetails;
    }

    public void setPaymentMethodDetails(PaymentMethodDetailItemList paymentMethodDetails) {
        this.paymentMethodDetails = paymentMethodDetails;
    }

    public ShipmentDetail marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @ApiModelProperty(value="The identifier for the marketplace where the order was placed.")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public ShipmentDetail sellerId(String sellerId) {
        this.sellerId = sellerId;
        return this;
    }

    @ApiModelProperty(value="The seller identifier.")
    public String getSellerId() {
        return this.sellerId;
    }

    public void setSellerId(String sellerId) {
        this.sellerId = sellerId;
    }

    public ShipmentDetail buyerName(String buyerName) {
        this.buyerName = buyerName;
        return this;
    }

    @ApiModelProperty(value="The name of the buyer.")
    public String getBuyerName() {
        return this.buyerName;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }

    public ShipmentDetail buyerCounty(String buyerCounty) {
        this.buyerCounty = buyerCounty;
        return this;
    }

    @ApiModelProperty(value="The county of the buyer.")
    public String getBuyerCounty() {
        return this.buyerCounty;
    }

    public void setBuyerCounty(String buyerCounty) {
        this.buyerCounty = buyerCounty;
    }

    public ShipmentDetail buyerTaxInfo(BuyerTaxInfo buyerTaxInfo) {
        this.buyerTaxInfo = buyerTaxInfo;
        return this;
    }

    @ApiModelProperty(value="")
    public BuyerTaxInfo getBuyerTaxInfo() {
        return this.buyerTaxInfo;
    }

    public void setBuyerTaxInfo(BuyerTaxInfo buyerTaxInfo) {
        this.buyerTaxInfo = buyerTaxInfo;
    }

    public ShipmentDetail marketplaceTaxInfo(MarketplaceTaxInfo marketplaceTaxInfo) {
        this.marketplaceTaxInfo = marketplaceTaxInfo;
        return this;
    }

    @ApiModelProperty(value="")
    public MarketplaceTaxInfo getMarketplaceTaxInfo() {
        return this.marketplaceTaxInfo;
    }

    public void setMarketplaceTaxInfo(MarketplaceTaxInfo marketplaceTaxInfo) {
        this.marketplaceTaxInfo = marketplaceTaxInfo;
    }

    public ShipmentDetail sellerDisplayName(String sellerDisplayName) {
        this.sellerDisplayName = sellerDisplayName;
        return this;
    }

    @ApiModelProperty(value="The seller\u2019s friendly name registered in the marketplace.")
    public String getSellerDisplayName() {
        return this.sellerDisplayName;
    }

    public void setSellerDisplayName(String sellerDisplayName) {
        this.sellerDisplayName = sellerDisplayName;
    }

    public ShipmentDetail shipmentItems(ShipmentItems shipmentItems) {
        this.shipmentItems = shipmentItems;
        return this;
    }

    @ApiModelProperty(value="")
    public ShipmentItems getShipmentItems() {
        return this.shipmentItems;
    }

    public void setShipmentItems(ShipmentItems shipmentItems) {
        this.shipmentItems = shipmentItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShipmentDetail shipmentDetail = (ShipmentDetail)o;
        return Objects.equals(this.warehouseId, shipmentDetail.warehouseId) && Objects.equals(this.amazonOrderId, shipmentDetail.amazonOrderId) && Objects.equals(this.amazonShipmentId, shipmentDetail.amazonShipmentId) && Objects.equals(this.purchaseDate, shipmentDetail.purchaseDate) && Objects.equals(this.shippingAddress, shipmentDetail.shippingAddress) && Objects.equals(this.paymentMethodDetails, shipmentDetail.paymentMethodDetails) && Objects.equals(this.marketplaceId, shipmentDetail.marketplaceId) && Objects.equals(this.sellerId, shipmentDetail.sellerId) && Objects.equals(this.buyerName, shipmentDetail.buyerName) && Objects.equals(this.buyerCounty, shipmentDetail.buyerCounty) && Objects.equals(this.buyerTaxInfo, shipmentDetail.buyerTaxInfo) && Objects.equals(this.marketplaceTaxInfo, shipmentDetail.marketplaceTaxInfo) && Objects.equals(this.sellerDisplayName, shipmentDetail.sellerDisplayName) && Objects.equals(this.shipmentItems, shipmentDetail.shipmentItems);
    }

    public int hashCode() {
        return Objects.hash(this.warehouseId, this.amazonOrderId, this.amazonShipmentId, this.purchaseDate, this.shippingAddress, this.paymentMethodDetails, this.marketplaceId, this.sellerId, this.buyerName, this.buyerCounty, this.buyerTaxInfo, this.marketplaceTaxInfo, this.sellerDisplayName, this.shipmentItems);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShipmentDetail {\n");
        sb.append("    warehouseId: ").append(this.toIndentedString(this.warehouseId)).append("\n");
        sb.append("    amazonOrderId: ").append(this.toIndentedString(this.amazonOrderId)).append("\n");
        sb.append("    amazonShipmentId: ").append(this.toIndentedString(this.amazonShipmentId)).append("\n");
        sb.append("    purchaseDate: ").append(this.toIndentedString(this.purchaseDate)).append("\n");
        sb.append("    shippingAddress: ").append(this.toIndentedString(this.shippingAddress)).append("\n");
        sb.append("    paymentMethodDetails: ").append(this.toIndentedString(this.paymentMethodDetails)).append("\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    sellerId: ").append(this.toIndentedString(this.sellerId)).append("\n");
        sb.append("    buyerName: ").append(this.toIndentedString(this.buyerName)).append("\n");
        sb.append("    buyerCounty: ").append(this.toIndentedString(this.buyerCounty)).append("\n");
        sb.append("    buyerTaxInfo: ").append(this.toIndentedString(this.buyerTaxInfo)).append("\n");
        sb.append("    marketplaceTaxInfo: ").append(this.toIndentedString(this.marketplaceTaxInfo)).append("\n");
        sb.append("    sellerDisplayName: ").append(this.toIndentedString(this.sellerDisplayName)).append("\n");
        sb.append("    shipmentItems: ").append(this.toIndentedString(this.shipmentItems)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

