/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.services;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Warning returned when the request is successful but execution have some important callouts on basis of which API clients should take defined actions.")
public class Warning {
    @SerializedName(value="code")
    private String code = null;
    @SerializedName(value="message")
    private String message = null;
    @SerializedName(value="details")
    private String details = null;

    public Warning code(String code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(required=true, value="An warning code that identifies the type of warning that occurred.")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Warning message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(required=true, value="A message that describes the warning condition in a human-readable form.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Warning details(String details) {
        this.details = details;
        return this;
    }

    @ApiModelProperty(value="Additional details that can help the caller understand or address the warning.")
    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Warning warning = (Warning)o;
        return Objects.equals(this.code, warning.code) && Objects.equals(this.message, warning.message) && Objects.equals(this.details, warning.details);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.message, this.details);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Warning {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

