/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.reports;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Detailed information about the report.")
public class Report {
    @SerializedName(value="marketplaceIds")
    private List<String> marketplaceIds = null;
    @SerializedName(value="reportId")
    private String reportId = null;
    @SerializedName(value="reportType")
    private String reportType = null;
    @SerializedName(value="dataStartTime")
    private OffsetDateTime dataStartTime = null;
    @SerializedName(value="dataEndTime")
    private OffsetDateTime dataEndTime = null;
    @SerializedName(value="reportScheduleId")
    private String reportScheduleId = null;
    @SerializedName(value="createdTime")
    private OffsetDateTime createdTime = null;
    @SerializedName(value="processingStatus")
    private ProcessingStatusEnum processingStatus = null;
    @SerializedName(value="processingStartTime")
    private OffsetDateTime processingStartTime = null;
    @SerializedName(value="processingEndTime")
    private OffsetDateTime processingEndTime = null;
    @SerializedName(value="reportDocumentId")
    private String reportDocumentId = null;

    public Report marketplaceIds(List<String> marketplaceIds) {
        this.marketplaceIds = marketplaceIds;
        return this;
    }

    public Report addMarketplaceIdsItem(String marketplaceIdsItem) {
        if (this.marketplaceIds == null) {
            this.marketplaceIds = new ArrayList<String>();
        }
        this.marketplaceIds.add(marketplaceIdsItem);
        return this;
    }

    @ApiModelProperty(value="A list of marketplace identifiers for the report.")
    public List<String> getMarketplaceIds() {
        return this.marketplaceIds;
    }

    public void setMarketplaceIds(List<String> marketplaceIds) {
        this.marketplaceIds = marketplaceIds;
    }

    public Report reportId(String reportId) {
        this.reportId = reportId;
        return this;
    }

    @ApiModelProperty(required=true, value="The identifier for the report. This identifier is unique only in combination with a seller ID.")
    public String getReportId() {
        return this.reportId;
    }

    public void setReportId(String reportId) {
        this.reportId = reportId;
    }

    public Report reportType(String reportType) {
        this.reportType = reportType;
        return this;
    }

    @ApiModelProperty(required=true, value="The report type.")
    public String getReportType() {
        return this.reportType;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public Report dataStartTime(OffsetDateTime dataStartTime) {
        this.dataStartTime = dataStartTime;
        return this;
    }

    @ApiModelProperty(value="The start of a date and time range used for selecting the data to report.")
    public OffsetDateTime getDataStartTime() {
        return this.dataStartTime;
    }

    public void setDataStartTime(OffsetDateTime dataStartTime) {
        this.dataStartTime = dataStartTime;
    }

    public Report dataEndTime(OffsetDateTime dataEndTime) {
        this.dataEndTime = dataEndTime;
        return this;
    }

    @ApiModelProperty(value="The end of a date and time range used for selecting the data to report.")
    public OffsetDateTime getDataEndTime() {
        return this.dataEndTime;
    }

    public void setDataEndTime(OffsetDateTime dataEndTime) {
        this.dataEndTime = dataEndTime;
    }

    public Report reportScheduleId(String reportScheduleId) {
        this.reportScheduleId = reportScheduleId;
        return this;
    }

    @ApiModelProperty(value="The identifier of the report schedule that created this report (if any). This identifier is unique only in combination with a seller ID.")
    public String getReportScheduleId() {
        return this.reportScheduleId;
    }

    public void setReportScheduleId(String reportScheduleId) {
        this.reportScheduleId = reportScheduleId;
    }

    public Report createdTime(OffsetDateTime createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    @ApiModelProperty(required=true, value="The date and time when the report was created.")
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(OffsetDateTime createdTime) {
        this.createdTime = createdTime;
    }

    public Report processingStatus(ProcessingStatusEnum processingStatus) {
        this.processingStatus = processingStatus;
        return this;
    }

    @ApiModelProperty(required=true, value="The processing status of the report.")
    public ProcessingStatusEnum getProcessingStatus() {
        return this.processingStatus;
    }

    public void setProcessingStatus(ProcessingStatusEnum processingStatus) {
        this.processingStatus = processingStatus;
    }

    public Report processingStartTime(OffsetDateTime processingStartTime) {
        this.processingStartTime = processingStartTime;
        return this;
    }

    @ApiModelProperty(value="The date and time when the report processing started, in ISO 8601 date time format.")
    public OffsetDateTime getProcessingStartTime() {
        return this.processingStartTime;
    }

    public void setProcessingStartTime(OffsetDateTime processingStartTime) {
        this.processingStartTime = processingStartTime;
    }

    public Report processingEndTime(OffsetDateTime processingEndTime) {
        this.processingEndTime = processingEndTime;
        return this;
    }

    @ApiModelProperty(value="The date and time when the report processing completed, in ISO 8601 date time format.")
    public OffsetDateTime getProcessingEndTime() {
        return this.processingEndTime;
    }

    public void setProcessingEndTime(OffsetDateTime processingEndTime) {
        this.processingEndTime = processingEndTime;
    }

    public Report reportDocumentId(String reportDocumentId) {
        this.reportDocumentId = reportDocumentId;
        return this;
    }

    @ApiModelProperty(value="The identifier for the report document. Pass this into the getReportDocument operation to get the information you will need to retrieve the report document's contents.")
    public String getReportDocumentId() {
        return this.reportDocumentId;
    }

    public void setReportDocumentId(String reportDocumentId) {
        this.reportDocumentId = reportDocumentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Report report = (Report)o;
        return Objects.equals(this.marketplaceIds, report.marketplaceIds) && Objects.equals(this.reportId, report.reportId) && Objects.equals(this.reportType, report.reportType) && Objects.equals(this.dataStartTime, report.dataStartTime) && Objects.equals(this.dataEndTime, report.dataEndTime) && Objects.equals(this.reportScheduleId, report.reportScheduleId) && Objects.equals(this.createdTime, report.createdTime) && Objects.equals((Object)this.processingStatus, (Object)report.processingStatus) && Objects.equals(this.processingStartTime, report.processingStartTime) && Objects.equals(this.processingEndTime, report.processingEndTime) && Objects.equals(this.reportDocumentId, report.reportDocumentId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.marketplaceIds, this.reportId, this.reportType, this.dataStartTime, this.dataEndTime, this.reportScheduleId, this.createdTime, this.processingStatus, this.processingStartTime, this.processingEndTime, this.reportDocumentId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Report {\n");
        sb.append("    marketplaceIds: ").append(this.toIndentedString(this.marketplaceIds)).append("\n");
        sb.append("    reportId: ").append(this.toIndentedString(this.reportId)).append("\n");
        sb.append("    reportType: ").append(this.toIndentedString(this.reportType)).append("\n");
        sb.append("    dataStartTime: ").append(this.toIndentedString(this.dataStartTime)).append("\n");
        sb.append("    dataEndTime: ").append(this.toIndentedString(this.dataEndTime)).append("\n");
        sb.append("    reportScheduleId: ").append(this.toIndentedString(this.reportScheduleId)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    processingStatus: ").append(this.toIndentedString((Object)this.processingStatus)).append("\n");
        sb.append("    processingStartTime: ").append(this.toIndentedString(this.processingStartTime)).append("\n");
        sb.append("    processingEndTime: ").append(this.toIndentedString(this.processingEndTime)).append("\n");
        sb.append("    reportDocumentId: ").append(this.toIndentedString(this.reportDocumentId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ProcessingStatusEnum {
        CANCELLED("CANCELLED"),
        DONE("DONE"),
        FATAL("FATAL"),
        IN_PROGRESS("IN_PROGRESS"),
        IN_QUEUE("IN_QUEUE");

        private String value;

        private ProcessingStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ProcessingStatusEnum fromValue(String text) {
            for (ProcessingStatusEnum b : ProcessingStatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ProcessingStatusEnum> {
            public void write(JsonWriter jsonWriter, ProcessingStatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ProcessingStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ProcessingStatusEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

