/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.productpricing;

import com.amazon.spapi.model.productpricing.BuyBoxEligibleOffers;
import com.amazon.spapi.model.productpricing.BuyBoxPrices;
import com.amazon.spapi.model.productpricing.LowestPrices;
import com.amazon.spapi.model.productpricing.MoneyType;
import com.amazon.spapi.model.productpricing.NumberOfOffers;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Contains price information about the product, including the LowestPrices and BuyBoxPrices, the ListPrice, the SuggestedLowerPricePlusShipping, and NumberOfOffers and NumberOfBuyBoxEligibleOffers.")
public class Summary {
    @SerializedName(value="TotalOfferCount")
    private Integer totalOfferCount = null;
    @SerializedName(value="NumberOfOffers")
    private NumberOfOffers numberOfOffers = null;
    @SerializedName(value="LowestPrices")
    private LowestPrices lowestPrices = null;
    @SerializedName(value="BuyBoxPrices")
    private BuyBoxPrices buyBoxPrices = null;
    @SerializedName(value="ListPrice")
    private MoneyType listPrice = null;
    @SerializedName(value="SuggestedLowerPricePlusShipping")
    private MoneyType suggestedLowerPricePlusShipping = null;
    @SerializedName(value="BuyBoxEligibleOffers")
    private BuyBoxEligibleOffers buyBoxEligibleOffers = null;
    @SerializedName(value="OffersAvailableTime")
    private OffsetDateTime offersAvailableTime = null;

    public Summary totalOfferCount(Integer totalOfferCount) {
        this.totalOfferCount = totalOfferCount;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of unique offers contained in NumberOfOffers.")
    public Integer getTotalOfferCount() {
        return this.totalOfferCount;
    }

    public void setTotalOfferCount(Integer totalOfferCount) {
        this.totalOfferCount = totalOfferCount;
    }

    public Summary numberOfOffers(NumberOfOffers numberOfOffers) {
        this.numberOfOffers = numberOfOffers;
        return this;
    }

    @ApiModelProperty(value="A list that contains the total number of offers for the item for the given conditions and fulfillment channels.")
    public NumberOfOffers getNumberOfOffers() {
        return this.numberOfOffers;
    }

    public void setNumberOfOffers(NumberOfOffers numberOfOffers) {
        this.numberOfOffers = numberOfOffers;
    }

    public Summary lowestPrices(LowestPrices lowestPrices) {
        this.lowestPrices = lowestPrices;
        return this;
    }

    @ApiModelProperty(value="A list of the lowest prices for the item.")
    public LowestPrices getLowestPrices() {
        return this.lowestPrices;
    }

    public void setLowestPrices(LowestPrices lowestPrices) {
        this.lowestPrices = lowestPrices;
    }

    public Summary buyBoxPrices(BuyBoxPrices buyBoxPrices) {
        this.buyBoxPrices = buyBoxPrices;
        return this;
    }

    @ApiModelProperty(value="A list of item prices.")
    public BuyBoxPrices getBuyBoxPrices() {
        return this.buyBoxPrices;
    }

    public void setBuyBoxPrices(BuyBoxPrices buyBoxPrices) {
        this.buyBoxPrices = buyBoxPrices;
    }

    public Summary listPrice(MoneyType listPrice) {
        this.listPrice = listPrice;
        return this;
    }

    @ApiModelProperty(value="The list price of the item as suggested by the manufacturer.")
    public MoneyType getListPrice() {
        return this.listPrice;
    }

    public void setListPrice(MoneyType listPrice) {
        this.listPrice = listPrice;
    }

    public Summary suggestedLowerPricePlusShipping(MoneyType suggestedLowerPricePlusShipping) {
        this.suggestedLowerPricePlusShipping = suggestedLowerPricePlusShipping;
        return this;
    }

    @ApiModelProperty(value="The suggested lower price of the item, including shipping and Amazon Points. The suggested lower price is based on a range of factors, including historical selling prices, recent Buy Box-eligible prices, and input from customers for your products.")
    public MoneyType getSuggestedLowerPricePlusShipping() {
        return this.suggestedLowerPricePlusShipping;
    }

    public void setSuggestedLowerPricePlusShipping(MoneyType suggestedLowerPricePlusShipping) {
        this.suggestedLowerPricePlusShipping = suggestedLowerPricePlusShipping;
    }

    public Summary buyBoxEligibleOffers(BuyBoxEligibleOffers buyBoxEligibleOffers) {
        this.buyBoxEligibleOffers = buyBoxEligibleOffers;
        return this;
    }

    @ApiModelProperty(value="A list that contains the total number of offers that are eligible for the Buy Box for the given conditions and fulfillment channels.")
    public BuyBoxEligibleOffers getBuyBoxEligibleOffers() {
        return this.buyBoxEligibleOffers;
    }

    public void setBuyBoxEligibleOffers(BuyBoxEligibleOffers buyBoxEligibleOffers) {
        this.buyBoxEligibleOffers = buyBoxEligibleOffers;
    }

    public Summary offersAvailableTime(OffsetDateTime offersAvailableTime) {
        this.offersAvailableTime = offersAvailableTime;
        return this;
    }

    @ApiModelProperty(value="When the status is ActiveButTooSoonForProcessing, this is the time when the offers will be available for processing.")
    public OffsetDateTime getOffersAvailableTime() {
        return this.offersAvailableTime;
    }

    public void setOffersAvailableTime(OffsetDateTime offersAvailableTime) {
        this.offersAvailableTime = offersAvailableTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Summary summary = (Summary)o;
        return Objects.equals(this.totalOfferCount, summary.totalOfferCount) && Objects.equals(this.numberOfOffers, summary.numberOfOffers) && Objects.equals(this.lowestPrices, summary.lowestPrices) && Objects.equals(this.buyBoxPrices, summary.buyBoxPrices) && Objects.equals(this.listPrice, summary.listPrice) && Objects.equals(this.suggestedLowerPricePlusShipping, summary.suggestedLowerPricePlusShipping) && Objects.equals(this.buyBoxEligibleOffers, summary.buyBoxEligibleOffers) && Objects.equals(this.offersAvailableTime, summary.offersAvailableTime);
    }

    public int hashCode() {
        return Objects.hash(this.totalOfferCount, this.numberOfOffers, this.lowestPrices, this.buyBoxPrices, this.listPrice, this.suggestedLowerPricePlusShipping, this.buyBoxEligibleOffers, this.offersAvailableTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Summary {\n");
        sb.append("    totalOfferCount: ").append(this.toIndentedString(this.totalOfferCount)).append("\n");
        sb.append("    numberOfOffers: ").append(this.toIndentedString(this.numberOfOffers)).append("\n");
        sb.append("    lowestPrices: ").append(this.toIndentedString(this.lowestPrices)).append("\n");
        sb.append("    buyBoxPrices: ").append(this.toIndentedString(this.buyBoxPrices)).append("\n");
        sb.append("    listPrice: ").append(this.toIndentedString(this.listPrice)).append("\n");
        sb.append("    suggestedLowerPricePlusShipping: ").append(this.toIndentedString(this.suggestedLowerPricePlusShipping)).append("\n");
        sb.append("    buyBoxEligibleOffers: ").append(this.toIndentedString(this.buyBoxEligibleOffers)).append("\n");
        sb.append("    offersAvailableTime: ").append(this.toIndentedString(this.offersAvailableTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

