/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.productpricing;

import com.amazon.spapi.model.productpricing.ConditionType;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Information that identifies an item.")
public class ItemIdentifier {
    @SerializedName(value="MarketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="ASIN")
    private String ASIN = null;
    @SerializedName(value="SellerSKU")
    private String sellerSKU = null;
    @SerializedName(value="ItemCondition")
    private ConditionType itemCondition = null;

    public ItemIdentifier marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @ApiModelProperty(required=true, value="A marketplace identifier. Specifies the marketplace from which prices are returned.")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public ItemIdentifier ASIN(String ASIN) {
        this.ASIN = ASIN;
        return this;
    }

    @ApiModelProperty(value="The Amazon Standard Identification Number (ASIN) of the item.")
    public String getASIN() {
        return this.ASIN;
    }

    public void setASIN(String ASIN) {
        this.ASIN = ASIN;
    }

    public ItemIdentifier sellerSKU(String sellerSKU) {
        this.sellerSKU = sellerSKU;
        return this;
    }

    @ApiModelProperty(value="The seller stock keeping unit (SKU) of the item.")
    public String getSellerSKU() {
        return this.sellerSKU;
    }

    public void setSellerSKU(String sellerSKU) {
        this.sellerSKU = sellerSKU;
    }

    public ItemIdentifier itemCondition(ConditionType itemCondition) {
        this.itemCondition = itemCondition;
        return this;
    }

    @ApiModelProperty(required=true, value="The condition of the item.")
    public ConditionType getItemCondition() {
        return this.itemCondition;
    }

    public void setItemCondition(ConditionType itemCondition) {
        this.itemCondition = itemCondition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemIdentifier itemIdentifier = (ItemIdentifier)o;
        return Objects.equals(this.marketplaceId, itemIdentifier.marketplaceId) && Objects.equals(this.ASIN, itemIdentifier.ASIN) && Objects.equals(this.sellerSKU, itemIdentifier.sellerSKU) && Objects.equals((Object)this.itemCondition, (Object)itemIdentifier.itemCondition);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.marketplaceId, this.ASIN, this.sellerSKU, this.itemCondition});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemIdentifier {\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    ASIN: ").append(this.toIndentedString(this.ASIN)).append("\n");
        sb.append("    sellerSKU: ").append(this.toIndentedString(this.sellerSKU)).append("\n");
        sb.append("    itemCondition: ").append(this.toIndentedString((Object)this.itemCondition)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

