/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.productpricing;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;

@ApiModel(description="The time range in which an item will likely be shipped once an order has been placed.")
public class DetailedShippingTimeType {
    @SerializedName(value="minimumHours")
    private Long minimumHours = null;
    @SerializedName(value="maximumHours")
    private Long maximumHours = null;
    @SerializedName(value="availableDate")
    private BigDecimal availableDate = null;
    @SerializedName(value="availabilityType")
    private AvailabilityTypeEnum availabilityType = null;

    public DetailedShippingTimeType minimumHours(Long minimumHours) {
        this.minimumHours = minimumHours;
        return this;
    }

    @ApiModelProperty(value="The minimum time, in hours, that the item will likely be shipped after the order has been placed.")
    public Long getMinimumHours() {
        return this.minimumHours;
    }

    public void setMinimumHours(Long minimumHours) {
        this.minimumHours = minimumHours;
    }

    public DetailedShippingTimeType maximumHours(Long maximumHours) {
        this.maximumHours = maximumHours;
        return this;
    }

    @ApiModelProperty(value="The maximum time, in hours, that the item will likely be shipped after the order has been placed.")
    public Long getMaximumHours() {
        return this.maximumHours;
    }

    public void setMaximumHours(Long maximumHours) {
        this.maximumHours = maximumHours;
    }

    public DetailedShippingTimeType availableDate(BigDecimal availableDate) {
        this.availableDate = availableDate;
        return this;
    }

    @ApiModelProperty(value="The date when the item will be available for shipping. Only displayed for items that are not currently available for shipping.")
    public BigDecimal getAvailableDate() {
        return this.availableDate;
    }

    public void setAvailableDate(BigDecimal availableDate) {
        this.availableDate = availableDate;
    }

    public DetailedShippingTimeType availabilityType(AvailabilityTypeEnum availabilityType) {
        this.availabilityType = availabilityType;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the item is available for shipping now, or on a known or an unknown date in the future. If known, the availableDate property indicates the date that the item will be available for shipping. Possible values: NOW, FUTURE_WITHOUT_DATE, FUTURE_WITH_DATE.")
    public AvailabilityTypeEnum getAvailabilityType() {
        return this.availabilityType;
    }

    public void setAvailabilityType(AvailabilityTypeEnum availabilityType) {
        this.availabilityType = availabilityType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DetailedShippingTimeType detailedShippingTimeType = (DetailedShippingTimeType)o;
        return Objects.equals(this.minimumHours, detailedShippingTimeType.minimumHours) && Objects.equals(this.maximumHours, detailedShippingTimeType.maximumHours) && Objects.equals(this.availableDate, detailedShippingTimeType.availableDate) && Objects.equals((Object)this.availabilityType, (Object)detailedShippingTimeType.availabilityType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.minimumHours, this.maximumHours, this.availableDate, this.availabilityType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DetailedShippingTimeType {\n");
        sb.append("    minimumHours: ").append(this.toIndentedString(this.minimumHours)).append("\n");
        sb.append("    maximumHours: ").append(this.toIndentedString(this.maximumHours)).append("\n");
        sb.append("    availableDate: ").append(this.toIndentedString(this.availableDate)).append("\n");
        sb.append("    availabilityType: ").append(this.toIndentedString((Object)this.availabilityType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AvailabilityTypeEnum {
        NOW("NOW"),
        FUTURE_WITHOUT_DATE("FUTURE_WITHOUT_DATE"),
        FUTURE_WITH_DATE("FUTURE_WITH_DATE");

        private String value;

        private AvailabilityTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AvailabilityTypeEnum fromValue(String text) {
            for (AvailabilityTypeEnum b : AvailabilityTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<AvailabilityTypeEnum> {
            public void write(JsonWriter jsonWriter, AvailabilityTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AvailabilityTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AvailabilityTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

