/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.productfees;

import com.amazon.spapi.model.productfees.MoneyType;
import com.amazon.spapi.model.productfees.Points;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Price information for an item, used to estimate fees.")
public class PriceToEstimateFees {
    @SerializedName(value="ListingPrice")
    private MoneyType listingPrice = null;
    @SerializedName(value="Shipping")
    private MoneyType shipping = null;
    @SerializedName(value="Points")
    private Points points = null;

    public PriceToEstimateFees listingPrice(MoneyType listingPrice) {
        this.listingPrice = listingPrice;
        return this;
    }

    @ApiModelProperty(required=true, value="The price of the item.")
    public MoneyType getListingPrice() {
        return this.listingPrice;
    }

    public void setListingPrice(MoneyType listingPrice) {
        this.listingPrice = listingPrice;
    }

    public PriceToEstimateFees shipping(MoneyType shipping) {
        this.shipping = shipping;
        return this;
    }

    @ApiModelProperty(value="The shipping cost.")
    public MoneyType getShipping() {
        return this.shipping;
    }

    public void setShipping(MoneyType shipping) {
        this.shipping = shipping;
    }

    public PriceToEstimateFees points(Points points) {
        this.points = points;
        return this;
    }

    @ApiModelProperty(value="The number of Amazon Points offered with the purchase of an item.")
    public Points getPoints() {
        return this.points;
    }

    public void setPoints(Points points) {
        this.points = points;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PriceToEstimateFees priceToEstimateFees = (PriceToEstimateFees)o;
        return Objects.equals(this.listingPrice, priceToEstimateFees.listingPrice) && Objects.equals(this.shipping, priceToEstimateFees.shipping) && Objects.equals(this.points, priceToEstimateFees.points);
    }

    public int hashCode() {
        return Objects.hash(this.listingPrice, this.shipping, this.points);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PriceToEstimateFees {\n");
        sb.append("    listingPrice: ").append(this.toIndentedString(this.listingPrice)).append("\n");
        sb.append("    shipping: ").append(this.toIndentedString(this.shipping)).append("\n");
        sb.append("    points: ").append(this.toIndentedString(this.points)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

