/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.productfees;

import com.amazon.spapi.model.productfees.PriceToEstimateFees;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="An item identifier, marketplace, time of request, and other details that identify an estimate.")
public class FeesEstimateIdentifier {
    @SerializedName(value="MarketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="SellerId")
    private String sellerId = null;
    @SerializedName(value="IdType")
    private String idType = null;
    @SerializedName(value="IdValue")
    private String idValue = null;
    @SerializedName(value="IsAmazonFulfilled")
    private Boolean isAmazonFulfilled = null;
    @SerializedName(value="PriceToEstimateFees")
    private PriceToEstimateFees priceToEstimateFees = null;
    @SerializedName(value="SellerInputIdentifier")
    private String sellerInputIdentifier = null;

    public FeesEstimateIdentifier marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @ApiModelProperty(value="A marketplace identifier.")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public FeesEstimateIdentifier sellerId(String sellerId) {
        this.sellerId = sellerId;
        return this;
    }

    @ApiModelProperty(value="The seller identifier.")
    public String getSellerId() {
        return this.sellerId;
    }

    public void setSellerId(String sellerId) {
        this.sellerId = sellerId;
    }

    public FeesEstimateIdentifier idType(String idType) {
        this.idType = idType;
        return this;
    }

    @ApiModelProperty(value="The type of item identifier specified.")
    public String getIdType() {
        return this.idType;
    }

    public void setIdType(String idType) {
        this.idType = idType;
    }

    public FeesEstimateIdentifier idValue(String idValue) {
        this.idValue = idValue;
        return this;
    }

    @ApiModelProperty(value="The item identifier.")
    public String getIdValue() {
        return this.idValue;
    }

    public void setIdValue(String idValue) {
        this.idValue = idValue;
    }

    public FeesEstimateIdentifier isAmazonFulfilled(Boolean isAmazonFulfilled) {
        this.isAmazonFulfilled = isAmazonFulfilled;
        return this;
    }

    @ApiModelProperty(value="When true, the offer is fulfilled by Amazon.")
    public Boolean isIsAmazonFulfilled() {
        return this.isAmazonFulfilled;
    }

    public void setIsAmazonFulfilled(Boolean isAmazonFulfilled) {
        this.isAmazonFulfilled = isAmazonFulfilled;
    }

    public FeesEstimateIdentifier priceToEstimateFees(PriceToEstimateFees priceToEstimateFees) {
        this.priceToEstimateFees = priceToEstimateFees;
        return this;
    }

    @ApiModelProperty(value="The item price on which the fee estimate is based.")
    public PriceToEstimateFees getPriceToEstimateFees() {
        return this.priceToEstimateFees;
    }

    public void setPriceToEstimateFees(PriceToEstimateFees priceToEstimateFees) {
        this.priceToEstimateFees = priceToEstimateFees;
    }

    public FeesEstimateIdentifier sellerInputIdentifier(String sellerInputIdentifier) {
        this.sellerInputIdentifier = sellerInputIdentifier;
        return this;
    }

    @ApiModelProperty(value="A unique identifier provided by the caller to track this request.")
    public String getSellerInputIdentifier() {
        return this.sellerInputIdentifier;
    }

    public void setSellerInputIdentifier(String sellerInputIdentifier) {
        this.sellerInputIdentifier = sellerInputIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeesEstimateIdentifier feesEstimateIdentifier = (FeesEstimateIdentifier)o;
        return Objects.equals(this.marketplaceId, feesEstimateIdentifier.marketplaceId) && Objects.equals(this.sellerId, feesEstimateIdentifier.sellerId) && Objects.equals(this.idType, feesEstimateIdentifier.idType) && Objects.equals(this.idValue, feesEstimateIdentifier.idValue) && Objects.equals(this.isAmazonFulfilled, feesEstimateIdentifier.isAmazonFulfilled) && Objects.equals(this.priceToEstimateFees, feesEstimateIdentifier.priceToEstimateFees) && Objects.equals(this.sellerInputIdentifier, feesEstimateIdentifier.sellerInputIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.marketplaceId, this.sellerId, this.idType, this.idValue, this.isAmazonFulfilled, this.priceToEstimateFees, this.sellerInputIdentifier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeesEstimateIdentifier {\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    sellerId: ").append(this.toIndentedString(this.sellerId)).append("\n");
        sb.append("    idType: ").append(this.toIndentedString(this.idType)).append("\n");
        sb.append("    idValue: ").append(this.toIndentedString(this.idValue)).append("\n");
        sb.append("    isAmazonFulfilled: ").append(this.toIndentedString(this.isAmazonFulfilled)).append("\n");
        sb.append("    priceToEstimateFees: ").append(this.toIndentedString(this.priceToEstimateFees)).append("\n");
        sb.append("    sellerInputIdentifier: ").append(this.toIndentedString(this.sellerInputIdentifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

