/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.orders;

import com.amazon.spapi.model.orders.RejectionReason;
import com.amazon.spapi.model.orders.VerificationStatus;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The verification status of the order along with associated approval or rejection metadata.")
public class RegulatedOrderVerificationStatus {
    @SerializedName(value="Status")
    private VerificationStatus status = null;
    @SerializedName(value="RequiresMerchantAction")
    private Boolean requiresMerchantAction = null;
    @SerializedName(value="ValidRejectionReasons")
    private List<RejectionReason> validRejectionReasons = new ArrayList<RejectionReason>();
    @SerializedName(value="RejectionReason")
    private RejectionReason rejectionReason = null;
    @SerializedName(value="ReviewDate")
    private String reviewDate = null;
    @SerializedName(value="ExternalReviewerId")
    private String externalReviewerId = null;

    public RegulatedOrderVerificationStatus status(VerificationStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="The verification status of the order.")
    public VerificationStatus getStatus() {
        return this.status;
    }

    public void setStatus(VerificationStatus status) {
        this.status = status;
    }

    public RegulatedOrderVerificationStatus requiresMerchantAction(Boolean requiresMerchantAction) {
        this.requiresMerchantAction = requiresMerchantAction;
        return this;
    }

    @ApiModelProperty(required=true, value="When true, the regulated information provided in the order requires a review by the merchant.")
    public Boolean isRequiresMerchantAction() {
        return this.requiresMerchantAction;
    }

    public void setRequiresMerchantAction(Boolean requiresMerchantAction) {
        this.requiresMerchantAction = requiresMerchantAction;
    }

    public RegulatedOrderVerificationStatus validRejectionReasons(List<RejectionReason> validRejectionReasons) {
        this.validRejectionReasons = validRejectionReasons;
        return this;
    }

    public RegulatedOrderVerificationStatus addValidRejectionReasonsItem(RejectionReason validRejectionReasonsItem) {
        this.validRejectionReasons.add(validRejectionReasonsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of valid rejection reasons that may be used to reject the order's regulated information.")
    public List<RejectionReason> getValidRejectionReasons() {
        return this.validRejectionReasons;
    }

    public void setValidRejectionReasons(List<RejectionReason> validRejectionReasons) {
        this.validRejectionReasons = validRejectionReasons;
    }

    public RegulatedOrderVerificationStatus rejectionReason(RejectionReason rejectionReason) {
        this.rejectionReason = rejectionReason;
        return this;
    }

    @ApiModelProperty(value="The reason for rejecting the order's regulated information. Not present if the order isn't rejected.")
    public RejectionReason getRejectionReason() {
        return this.rejectionReason;
    }

    public void setRejectionReason(RejectionReason rejectionReason) {
        this.rejectionReason = rejectionReason;
    }

    public RegulatedOrderVerificationStatus reviewDate(String reviewDate) {
        this.reviewDate = reviewDate;
        return this;
    }

    @ApiModelProperty(value="The date the order was reviewed. In ISO 8601 date time format.")
    public String getReviewDate() {
        return this.reviewDate;
    }

    public void setReviewDate(String reviewDate) {
        this.reviewDate = reviewDate;
    }

    public RegulatedOrderVerificationStatus externalReviewerId(String externalReviewerId) {
        this.externalReviewerId = externalReviewerId;
        return this;
    }

    @ApiModelProperty(value="The identifier for the order's regulated information reviewer.")
    public String getExternalReviewerId() {
        return this.externalReviewerId;
    }

    public void setExternalReviewerId(String externalReviewerId) {
        this.externalReviewerId = externalReviewerId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegulatedOrderVerificationStatus regulatedOrderVerificationStatus = (RegulatedOrderVerificationStatus)o;
        return Objects.equals((Object)this.status, (Object)regulatedOrderVerificationStatus.status) && Objects.equals(this.requiresMerchantAction, regulatedOrderVerificationStatus.requiresMerchantAction) && Objects.equals(this.validRejectionReasons, regulatedOrderVerificationStatus.validRejectionReasons) && Objects.equals(this.rejectionReason, regulatedOrderVerificationStatus.rejectionReason) && Objects.equals(this.reviewDate, regulatedOrderVerificationStatus.reviewDate) && Objects.equals(this.externalReviewerId, regulatedOrderVerificationStatus.externalReviewerId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.requiresMerchantAction, this.validRejectionReasons, this.rejectionReason, this.reviewDate, this.externalReviewerId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RegulatedOrderVerificationStatus {\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    requiresMerchantAction: ").append(this.toIndentedString(this.requiresMerchantAction)).append("\n");
        sb.append("    validRejectionReasons: ").append(this.toIndentedString(this.validRejectionReasons)).append("\n");
        sb.append("    rejectionReason: ").append(this.toIndentedString(this.rejectionReason)).append("\n");
        sb.append("    reviewDate: ").append(this.toIndentedString(this.reviewDate)).append("\n");
        sb.append("    externalReviewerId: ").append(this.toIndentedString(this.externalReviewerId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

