/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.orders;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="A field collected from the regulatory form.")
public class RegulatedInformationField {
    @SerializedName(value="FieldId")
    private String fieldId = null;
    @SerializedName(value="FieldLabel")
    private String fieldLabel = null;
    @SerializedName(value="FieldType")
    private FieldTypeEnum fieldType = null;
    @SerializedName(value="FieldValue")
    private String fieldValue = null;

    public RegulatedInformationField fieldId(String fieldId) {
        this.fieldId = fieldId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier for the field.")
    public String getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public RegulatedInformationField fieldLabel(String fieldLabel) {
        this.fieldLabel = fieldLabel;
        return this;
    }

    @ApiModelProperty(required=true, value="The name for the field.")
    public String getFieldLabel() {
        return this.fieldLabel;
    }

    public void setFieldLabel(String fieldLabel) {
        this.fieldLabel = fieldLabel;
    }

    public RegulatedInformationField fieldType(FieldTypeEnum fieldType) {
        this.fieldType = fieldType;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of field.")
    public FieldTypeEnum getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(FieldTypeEnum fieldType) {
        this.fieldType = fieldType;
    }

    public RegulatedInformationField fieldValue(String fieldValue) {
        this.fieldValue = fieldValue;
        return this;
    }

    @ApiModelProperty(required=true, value="The content of the field as collected in regulatory form. Note that FileAttachment type fields will contain a URL to download the attachment here.")
    public String getFieldValue() {
        return this.fieldValue;
    }

    public void setFieldValue(String fieldValue) {
        this.fieldValue = fieldValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegulatedInformationField regulatedInformationField = (RegulatedInformationField)o;
        return Objects.equals(this.fieldId, regulatedInformationField.fieldId) && Objects.equals(this.fieldLabel, regulatedInformationField.fieldLabel) && Objects.equals((Object)this.fieldType, (Object)regulatedInformationField.fieldType) && Objects.equals(this.fieldValue, regulatedInformationField.fieldValue);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fieldId, this.fieldLabel, this.fieldType, this.fieldValue});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RegulatedInformationField {\n");
        sb.append("    fieldId: ").append(this.toIndentedString(this.fieldId)).append("\n");
        sb.append("    fieldLabel: ").append(this.toIndentedString(this.fieldLabel)).append("\n");
        sb.append("    fieldType: ").append(this.toIndentedString((Object)this.fieldType)).append("\n");
        sb.append("    fieldValue: ").append(this.toIndentedString(this.fieldValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FieldTypeEnum {
        TEXT("Text"),
        FILEATTACHMENT("FileAttachment");

        private String value;

        private FieldTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FieldTypeEnum fromValue(String text) {
            for (FieldTypeEnum b : FieldTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<FieldTypeEnum> {
            public void write(JsonWriter jsonWriter, FieldTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FieldTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FieldTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

