/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.orders;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="The shipping address for the order.")
public class Address {
    @SerializedName(value="Name")
    private String name = null;
    @SerializedName(value="AddressLine1")
    private String addressLine1 = null;
    @SerializedName(value="AddressLine2")
    private String addressLine2 = null;
    @SerializedName(value="AddressLine3")
    private String addressLine3 = null;
    @SerializedName(value="City")
    private String city = null;
    @SerializedName(value="County")
    private String county = null;
    @SerializedName(value="District")
    private String district = null;
    @SerializedName(value="StateOrRegion")
    private String stateOrRegion = null;
    @SerializedName(value="Municipality")
    private String municipality = null;
    @SerializedName(value="PostalCode")
    private String postalCode = null;
    @SerializedName(value="CountryCode")
    private String countryCode = null;
    @SerializedName(value="Phone")
    private String phone = null;
    @SerializedName(value="AddressType")
    private AddressTypeEnum addressType = null;

    public Address name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Address addressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
        return this;
    }

    @ApiModelProperty(value="The street address.")
    public String getAddressLine1() {
        return this.addressLine1;
    }

    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    public Address addressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
        return this;
    }

    @ApiModelProperty(value="Additional street address information, if required.")
    public String getAddressLine2() {
        return this.addressLine2;
    }

    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
    }

    public Address addressLine3(String addressLine3) {
        this.addressLine3 = addressLine3;
        return this;
    }

    @ApiModelProperty(value="Additional street address information, if required.")
    public String getAddressLine3() {
        return this.addressLine3;
    }

    public void setAddressLine3(String addressLine3) {
        this.addressLine3 = addressLine3;
    }

    public Address city(String city) {
        this.city = city;
        return this;
    }

    @ApiModelProperty(value="The city ")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public Address county(String county) {
        this.county = county;
        return this;
    }

    @ApiModelProperty(value="The county.")
    public String getCounty() {
        return this.county;
    }

    public void setCounty(String county) {
        this.county = county;
    }

    public Address district(String district) {
        this.district = district;
        return this;
    }

    @ApiModelProperty(value="The district.")
    public String getDistrict() {
        return this.district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public Address stateOrRegion(String stateOrRegion) {
        this.stateOrRegion = stateOrRegion;
        return this;
    }

    @ApiModelProperty(value="The state or region.")
    public String getStateOrRegion() {
        return this.stateOrRegion;
    }

    public void setStateOrRegion(String stateOrRegion) {
        this.stateOrRegion = stateOrRegion;
    }

    public Address municipality(String municipality) {
        this.municipality = municipality;
        return this;
    }

    @ApiModelProperty(value="The municipality.")
    public String getMunicipality() {
        return this.municipality;
    }

    public void setMunicipality(String municipality) {
        this.municipality = municipality;
    }

    public Address postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @ApiModelProperty(value="The postal code.")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public Address countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(value="The country code. A two-character country code, in ISO 3166-1 alpha-2 format.")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public Address phone(String phone) {
        this.phone = phone;
        return this;
    }

    @ApiModelProperty(value="The phone number. Not returned for Fulfillment by Amazon (FBA) orders.")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Address addressType(AddressTypeEnum addressType) {
        this.addressType = addressType;
        return this;
    }

    @ApiModelProperty(value="The address type of the shipping address.")
    public AddressTypeEnum getAddressType() {
        return this.addressType;
    }

    public void setAddressType(AddressTypeEnum addressType) {
        this.addressType = addressType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return Objects.equals(this.name, address.name) && Objects.equals(this.addressLine1, address.addressLine1) && Objects.equals(this.addressLine2, address.addressLine2) && Objects.equals(this.addressLine3, address.addressLine3) && Objects.equals(this.city, address.city) && Objects.equals(this.county, address.county) && Objects.equals(this.district, address.district) && Objects.equals(this.stateOrRegion, address.stateOrRegion) && Objects.equals(this.municipality, address.municipality) && Objects.equals(this.postalCode, address.postalCode) && Objects.equals(this.countryCode, address.countryCode) && Objects.equals(this.phone, address.phone) && Objects.equals((Object)this.addressType, (Object)address.addressType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.addressLine1, this.addressLine2, this.addressLine3, this.city, this.county, this.district, this.stateOrRegion, this.municipality, this.postalCode, this.countryCode, this.phone, this.addressType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Address {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    addressLine1: ").append(this.toIndentedString(this.addressLine1)).append("\n");
        sb.append("    addressLine2: ").append(this.toIndentedString(this.addressLine2)).append("\n");
        sb.append("    addressLine3: ").append(this.toIndentedString(this.addressLine3)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    county: ").append(this.toIndentedString(this.county)).append("\n");
        sb.append("    district: ").append(this.toIndentedString(this.district)).append("\n");
        sb.append("    stateOrRegion: ").append(this.toIndentedString(this.stateOrRegion)).append("\n");
        sb.append("    municipality: ").append(this.toIndentedString(this.municipality)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    addressType: ").append(this.toIndentedString((Object)this.addressType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AddressTypeEnum {
        RESIDENTIAL("Residential"),
        COMMERCIAL("Commercial");

        private String value;

        private AddressTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AddressTypeEnum fromValue(String text) {
            for (AddressTypeEnum b : AddressTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<AddressTypeEnum> {
            public void write(JsonWriter jsonWriter, AddressTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AddressTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AddressTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

