/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.notifications;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents a subscription to receive notifications.")
public class Subscription {
    @SerializedName(value="subscriptionId")
    private String subscriptionId = null;
    @SerializedName(value="payloadVersion")
    private String payloadVersion = null;
    @SerializedName(value="destinationId")
    private String destinationId = null;

    public Subscription subscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    @ApiModelProperty(required=true, value="The subscription identifier generated when the subscription is created.")
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public Subscription payloadVersion(String payloadVersion) {
        this.payloadVersion = payloadVersion;
        return this;
    }

    @ApiModelProperty(required=true, value="The version of the payload object to be used in the notification.")
    public String getPayloadVersion() {
        return this.payloadVersion;
    }

    public void setPayloadVersion(String payloadVersion) {
        this.payloadVersion = payloadVersion;
    }

    public Subscription destinationId(String destinationId) {
        this.destinationId = destinationId;
        return this;
    }

    @ApiModelProperty(required=true, value="The identifier for the destination where notifications will be delivered.")
    public String getDestinationId() {
        return this.destinationId;
    }

    public void setDestinationId(String destinationId) {
        this.destinationId = destinationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subscription subscription = (Subscription)o;
        return Objects.equals(this.subscriptionId, subscription.subscriptionId) && Objects.equals(this.payloadVersion, subscription.payloadVersion) && Objects.equals(this.destinationId, subscription.destinationId);
    }

    public int hashCode() {
        return Objects.hash(this.subscriptionId, this.payloadVersion, this.destinationId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Subscription {\n");
        sb.append("    subscriptionId: ").append(this.toIndentedString(this.subscriptionId)).append("\n");
        sb.append("    payloadVersion: ").append(this.toIndentedString(this.payloadVersion)).append("\n");
        sb.append("    destinationId: ").append(this.toIndentedString(this.destinationId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

