/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.notifications;

import com.amazon.spapi.model.notifications.DestinationResource;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents a destination created when you call the createDestination operation.")
public class Destination {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="destinationId")
    private String destinationId = null;
    @SerializedName(value="resource")
    private DestinationResource resource = null;

    public Destination name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The developer-defined name for this destination.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Destination destinationId(String destinationId) {
        this.destinationId = destinationId;
        return this;
    }

    @ApiModelProperty(required=true, value="The destination identifier generated when you created the destination.")
    public String getDestinationId() {
        return this.destinationId;
    }

    public void setDestinationId(String destinationId) {
        this.destinationId = destinationId;
    }

    public Destination resource(DestinationResource resource) {
        this.resource = resource;
        return this;
    }

    @ApiModelProperty(required=true, value="The resource that will receive notifications associated with this destination.")
    public DestinationResource getResource() {
        return this.resource;
    }

    public void setResource(DestinationResource resource) {
        this.resource = resource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Destination destination = (Destination)o;
        return Objects.equals(this.name, destination.name) && Objects.equals(this.destinationId, destination.destinationId) && Objects.equals(this.resource, destination.resource);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.destinationId, this.resource);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Destination {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    destinationId: ").append(this.toIndentedString(this.destinationId)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

