/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.listingsrestrictions;

import com.amazon.spapi.model.listingsrestrictions.Reason;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A listing restriction, optionally qualified by a condition, with a list of reasons for the restriction.")
public class Restriction {
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="conditionType")
    private ConditionTypeEnum conditionType = null;
    @SerializedName(value="reasons")
    private List<Reason> reasons = null;

    public Restriction marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @ApiModelProperty(required=true, value="A marketplace identifier. Identifies the Amazon marketplace where the restriction is enforced.")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public Restriction conditionType(ConditionTypeEnum conditionType) {
        this.conditionType = conditionType;
        return this;
    }

    @ApiModelProperty(value="The condition that applies to the restriction.")
    public ConditionTypeEnum getConditionType() {
        return this.conditionType;
    }

    public void setConditionType(ConditionTypeEnum conditionType) {
        this.conditionType = conditionType;
    }

    public Restriction reasons(List<Reason> reasons) {
        this.reasons = reasons;
        return this;
    }

    public Restriction addReasonsItem(Reason reasonsItem) {
        if (this.reasons == null) {
            this.reasons = new ArrayList<Reason>();
        }
        this.reasons.add(reasonsItem);
        return this;
    }

    @ApiModelProperty(value="A list of reasons for the restriction.")
    public List<Reason> getReasons() {
        return this.reasons;
    }

    public void setReasons(List<Reason> reasons) {
        this.reasons = reasons;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Restriction restriction = (Restriction)o;
        return Objects.equals(this.marketplaceId, restriction.marketplaceId) && Objects.equals((Object)this.conditionType, (Object)restriction.conditionType) && Objects.equals(this.reasons, restriction.reasons);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.marketplaceId, this.conditionType, this.reasons});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Restriction {\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    conditionType: ").append(this.toIndentedString((Object)this.conditionType)).append("\n");
        sb.append("    reasons: ").append(this.toIndentedString(this.reasons)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ConditionTypeEnum {
        NEW_NEW("new_new"),
        NEW_OPEN_BOX("new_open_box"),
        NEW_OEM("new_oem"),
        REFURBISHED_REFURBISHED("refurbished_refurbished"),
        USED_LIKE_NEW("used_like_new"),
        USED_VERY_GOOD("used_very_good"),
        USED_GOOD("used_good"),
        USED_ACCEPTABLE("used_acceptable"),
        COLLECTIBLE_LIKE_NEW("collectible_like_new"),
        COLLECTIBLE_VERY_GOOD("collectible_very_good"),
        COLLECTIBLE_GOOD("collectible_good"),
        COLLECTIBLE_ACCEPTABLE("collectible_acceptable"),
        CLUB_CLUB("club_club");

        private String value;

        private ConditionTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ConditionTypeEnum fromValue(String text) {
            for (ConditionTypeEnum b : ConditionTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ConditionTypeEnum> {
            public void write(JsonWriter jsonWriter, ConditionTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ConditionTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ConditionTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

