/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.listingsitems;

import com.amazon.spapi.model.listingsitems.Issue;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Response containing the results of a submission to the Selling Partner API for Listings Items.")
public class ListingsItemSubmissionResponse {
    @SerializedName(value="sku")
    private String sku = null;
    @SerializedName(value="status")
    private StatusEnum status = null;
    @SerializedName(value="submissionId")
    private String submissionId = null;
    @SerializedName(value="issues")
    private List<Issue> issues = null;

    public ListingsItemSubmissionResponse sku(String sku) {
        this.sku = sku;
        return this;
    }

    @ApiModelProperty(required=true, value="A selling partner provided identifier for an Amazon listing.")
    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public ListingsItemSubmissionResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="The status of the listings item submission.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public ListingsItemSubmissionResponse submissionId(String submissionId) {
        this.submissionId = submissionId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the listings item submission.")
    public String getSubmissionId() {
        return this.submissionId;
    }

    public void setSubmissionId(String submissionId) {
        this.submissionId = submissionId;
    }

    public ListingsItemSubmissionResponse issues(List<Issue> issues) {
        this.issues = issues;
        return this;
    }

    public ListingsItemSubmissionResponse addIssuesItem(Issue issuesItem) {
        if (this.issues == null) {
            this.issues = new ArrayList<Issue>();
        }
        this.issues.add(issuesItem);
        return this;
    }

    @ApiModelProperty(value="Listings item issues related to the listings item submission.")
    public List<Issue> getIssues() {
        return this.issues;
    }

    public void setIssues(List<Issue> issues) {
        this.issues = issues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListingsItemSubmissionResponse listingsItemSubmissionResponse = (ListingsItemSubmissionResponse)o;
        return Objects.equals(this.sku, listingsItemSubmissionResponse.sku) && Objects.equals((Object)this.status, (Object)listingsItemSubmissionResponse.status) && Objects.equals(this.submissionId, listingsItemSubmissionResponse.submissionId) && Objects.equals(this.issues, listingsItemSubmissionResponse.issues);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sku, this.status, this.submissionId, this.issues});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListingsItemSubmissionResponse {\n");
        sb.append("    sku: ").append(this.toIndentedString(this.sku)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    submissionId: ").append(this.toIndentedString(this.submissionId)).append("\n");
        sb.append("    issues: ").append(this.toIndentedString(this.issues)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        ACCEPTED("ACCEPTED"),
        INVALID("INVALID");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

