/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.listingsitems;

import com.amazon.spapi.model.listingsitems.FulfillmentAvailability;
import com.amazon.spapi.model.listingsitems.ItemAttributes;
import com.amazon.spapi.model.listingsitems.ItemIssues;
import com.amazon.spapi.model.listingsitems.ItemOffers;
import com.amazon.spapi.model.listingsitems.ItemProcurement;
import com.amazon.spapi.model.listingsitems.ItemSummaries;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A listings item.")
public class Item {
    @SerializedName(value="sku")
    private String sku = null;
    @SerializedName(value="summaries")
    private ItemSummaries summaries = null;
    @SerializedName(value="attributes")
    private ItemAttributes attributes = null;
    @SerializedName(value="issues")
    private ItemIssues issues = null;
    @SerializedName(value="offers")
    private ItemOffers offers = null;
    @SerializedName(value="fulfillmentAvailability")
    private List<FulfillmentAvailability> fulfillmentAvailability = null;
    @SerializedName(value="procurement")
    private ItemProcurement procurement = null;

    public Item sku(String sku) {
        this.sku = sku;
        return this;
    }

    @ApiModelProperty(required=true, value="A selling partner provided identifier for an Amazon listing.")
    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public Item summaries(ItemSummaries summaries) {
        this.summaries = summaries;
        return this;
    }

    @ApiModelProperty(value="")
    public ItemSummaries getSummaries() {
        return this.summaries;
    }

    public void setSummaries(ItemSummaries summaries) {
        this.summaries = summaries;
    }

    public Item attributes(ItemAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(value="")
    public ItemAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(ItemAttributes attributes) {
        this.attributes = attributes;
    }

    public Item issues(ItemIssues issues) {
        this.issues = issues;
        return this;
    }

    @ApiModelProperty(value="")
    public ItemIssues getIssues() {
        return this.issues;
    }

    public void setIssues(ItemIssues issues) {
        this.issues = issues;
    }

    public Item offers(ItemOffers offers) {
        this.offers = offers;
        return this;
    }

    @ApiModelProperty(value="")
    public ItemOffers getOffers() {
        return this.offers;
    }

    public void setOffers(ItemOffers offers) {
        this.offers = offers;
    }

    public Item fulfillmentAvailability(List<FulfillmentAvailability> fulfillmentAvailability) {
        this.fulfillmentAvailability = fulfillmentAvailability;
        return this;
    }

    public Item addFulfillmentAvailabilityItem(FulfillmentAvailability fulfillmentAvailabilityItem) {
        if (this.fulfillmentAvailability == null) {
            this.fulfillmentAvailability = new ArrayList<FulfillmentAvailability>();
        }
        this.fulfillmentAvailability.add(fulfillmentAvailabilityItem);
        return this;
    }

    @ApiModelProperty(value="Fulfillment availability for the listings item.")
    public List<FulfillmentAvailability> getFulfillmentAvailability() {
        return this.fulfillmentAvailability;
    }

    public void setFulfillmentAvailability(List<FulfillmentAvailability> fulfillmentAvailability) {
        this.fulfillmentAvailability = fulfillmentAvailability;
    }

    public Item procurement(ItemProcurement procurement) {
        this.procurement = procurement;
        return this;
    }

    @ApiModelProperty(value="")
    public ItemProcurement getProcurement() {
        return this.procurement;
    }

    public void setProcurement(ItemProcurement procurement) {
        this.procurement = procurement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Item item = (Item)o;
        return Objects.equals(this.sku, item.sku) && Objects.equals(this.summaries, item.summaries) && Objects.equals(this.attributes, item.attributes) && Objects.equals(this.issues, item.issues) && Objects.equals(this.offers, item.offers) && Objects.equals(this.fulfillmentAvailability, item.fulfillmentAvailability) && Objects.equals(this.procurement, item.procurement);
    }

    public int hashCode() {
        return Objects.hash(this.sku, this.summaries, this.attributes, this.issues, this.offers, this.fulfillmentAvailability, this.procurement);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Item {\n");
        sb.append("    sku: ").append(this.toIndentedString(this.sku)).append("\n");
        sb.append("    summaries: ").append(this.toIndentedString(this.summaries)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    issues: ").append(this.toIndentedString(this.issues)).append("\n");
        sb.append("    offers: ").append(this.toIndentedString(this.offers)).append("\n");
        sb.append("    fulfillmentAvailability: ").append(this.toIndentedString(this.fulfillmentAvailability)).append("\n");
        sb.append("    procurement: ").append(this.toIndentedString(this.procurement)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

