/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.listingsitems;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="An issue with a listings item.")
public class Issue {
    @SerializedName(value="code")
    private String code = null;
    @SerializedName(value="message")
    private String message = null;
    @SerializedName(value="severity")
    private SeverityEnum severity = null;
    @SerializedName(value="attributeNames")
    private List<String> attributeNames = null;

    public Issue code(String code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(required=true, value="An issue code that identifies the type of issue.")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Issue message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(required=true, value="A message that describes the issue.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Issue severity(SeverityEnum severity) {
        this.severity = severity;
        return this;
    }

    @ApiModelProperty(required=true, value="The severity of the issue.")
    public SeverityEnum getSeverity() {
        return this.severity;
    }

    public void setSeverity(SeverityEnum severity) {
        this.severity = severity;
    }

    public Issue attributeNames(List<String> attributeNames) {
        this.attributeNames = attributeNames;
        return this;
    }

    public Issue addAttributeNamesItem(String attributeNamesItem) {
        if (this.attributeNames == null) {
            this.attributeNames = new ArrayList<String>();
        }
        this.attributeNames.add(attributeNamesItem);
        return this;
    }

    @ApiModelProperty(value="Names of the attributes associated with the issue, if applicable.")
    public List<String> getAttributeNames() {
        return this.attributeNames;
    }

    public void setAttributeNames(List<String> attributeNames) {
        this.attributeNames = attributeNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Issue issue = (Issue)o;
        return Objects.equals(this.code, issue.code) && Objects.equals(this.message, issue.message) && Objects.equals((Object)this.severity, (Object)issue.severity) && Objects.equals(this.attributeNames, issue.attributeNames);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.code, this.message, this.severity, this.attributeNames});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Issue {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    severity: ").append(this.toIndentedString((Object)this.severity)).append("\n");
        sb.append("    attributeNames: ").append(this.toIndentedString(this.attributeNames)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SeverityEnum {
        ERROR("ERROR"),
        WARNING("WARNING"),
        INFO("INFO");

        private String value;

        private SeverityEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SeverityEnum fromValue(String text) {
            for (SeverityEnum b : SeverityEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<SeverityEnum> {
            public void write(JsonWriter jsonWriter, SeverityEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SeverityEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SeverityEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

