/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fulfillmentoutbound;

import com.amazon.spapi.model.fulfillmentoutbound.Money;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Item information for updating a fulfillment order.")
public class UpdateFulfillmentOrderItem {
    @SerializedName(value="sellerSku")
    private String sellerSku = null;
    @SerializedName(value="sellerFulfillmentOrderItemId")
    private String sellerFulfillmentOrderItemId = null;
    @SerializedName(value="quantity")
    private Integer quantity = null;
    @SerializedName(value="giftMessage")
    private String giftMessage = null;
    @SerializedName(value="displayableComment")
    private String displayableComment = null;
    @SerializedName(value="fulfillmentNetworkSku")
    private String fulfillmentNetworkSku = null;
    @SerializedName(value="orderItemDisposition")
    private String orderItemDisposition = null;
    @SerializedName(value="perUnitDeclaredValue")
    private Money perUnitDeclaredValue = null;
    @SerializedName(value="perUnitPrice")
    private Money perUnitPrice = null;
    @SerializedName(value="perUnitTax")
    private Money perUnitTax = null;

    public UpdateFulfillmentOrderItem sellerSku(String sellerSku) {
        this.sellerSku = sellerSku;
        return this;
    }

    @ApiModelProperty(value="The seller SKU of the item.")
    public String getSellerSku() {
        return this.sellerSku;
    }

    public void setSellerSku(String sellerSku) {
        this.sellerSku = sellerSku;
    }

    public UpdateFulfillmentOrderItem sellerFulfillmentOrderItemId(String sellerFulfillmentOrderItemId) {
        this.sellerFulfillmentOrderItemId = sellerFulfillmentOrderItemId;
        return this;
    }

    @ApiModelProperty(required=true, value="Identifies the fulfillment order item to update. Created with a previous call to the createFulfillmentOrder operation.")
    public String getSellerFulfillmentOrderItemId() {
        return this.sellerFulfillmentOrderItemId;
    }

    public void setSellerFulfillmentOrderItemId(String sellerFulfillmentOrderItemId) {
        this.sellerFulfillmentOrderItemId = sellerFulfillmentOrderItemId;
    }

    public UpdateFulfillmentOrderItem quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public UpdateFulfillmentOrderItem giftMessage(String giftMessage) {
        this.giftMessage = giftMessage;
        return this;
    }

    @ApiModelProperty(value="A message to the gift recipient, if applicable.")
    public String getGiftMessage() {
        return this.giftMessage;
    }

    public void setGiftMessage(String giftMessage) {
        this.giftMessage = giftMessage;
    }

    public UpdateFulfillmentOrderItem displayableComment(String displayableComment) {
        this.displayableComment = displayableComment;
        return this;
    }

    @ApiModelProperty(value="Item-specific text that displays in recipient-facing materials such as the outbound shipment packing slip.")
    public String getDisplayableComment() {
        return this.displayableComment;
    }

    public void setDisplayableComment(String displayableComment) {
        this.displayableComment = displayableComment;
    }

    public UpdateFulfillmentOrderItem fulfillmentNetworkSku(String fulfillmentNetworkSku) {
        this.fulfillmentNetworkSku = fulfillmentNetworkSku;
        return this;
    }

    @ApiModelProperty(value="Amazon's fulfillment network SKU of the item.")
    public String getFulfillmentNetworkSku() {
        return this.fulfillmentNetworkSku;
    }

    public void setFulfillmentNetworkSku(String fulfillmentNetworkSku) {
        this.fulfillmentNetworkSku = fulfillmentNetworkSku;
    }

    public UpdateFulfillmentOrderItem orderItemDisposition(String orderItemDisposition) {
        this.orderItemDisposition = orderItemDisposition;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the item is sellable or unsellable.")
    public String getOrderItemDisposition() {
        return this.orderItemDisposition;
    }

    public void setOrderItemDisposition(String orderItemDisposition) {
        this.orderItemDisposition = orderItemDisposition;
    }

    public UpdateFulfillmentOrderItem perUnitDeclaredValue(Money perUnitDeclaredValue) {
        this.perUnitDeclaredValue = perUnitDeclaredValue;
        return this;
    }

    @ApiModelProperty(value="The monetary value assigned by the seller to this item.")
    public Money getPerUnitDeclaredValue() {
        return this.perUnitDeclaredValue;
    }

    public void setPerUnitDeclaredValue(Money perUnitDeclaredValue) {
        this.perUnitDeclaredValue = perUnitDeclaredValue;
    }

    public UpdateFulfillmentOrderItem perUnitPrice(Money perUnitPrice) {
        this.perUnitPrice = perUnitPrice;
        return this;
    }

    @ApiModelProperty(value="The amount to be collected from the recipient for this item in a COD (Cash On Delivery) order.")
    public Money getPerUnitPrice() {
        return this.perUnitPrice;
    }

    public void setPerUnitPrice(Money perUnitPrice) {
        this.perUnitPrice = perUnitPrice;
    }

    public UpdateFulfillmentOrderItem perUnitTax(Money perUnitTax) {
        this.perUnitTax = perUnitTax;
        return this;
    }

    @ApiModelProperty(value="The tax on the amount to be collected from the recipient for this item in a COD (Cash On Delivery) order.")
    public Money getPerUnitTax() {
        return this.perUnitTax;
    }

    public void setPerUnitTax(Money perUnitTax) {
        this.perUnitTax = perUnitTax;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateFulfillmentOrderItem updateFulfillmentOrderItem = (UpdateFulfillmentOrderItem)o;
        return Objects.equals(this.sellerSku, updateFulfillmentOrderItem.sellerSku) && Objects.equals(this.sellerFulfillmentOrderItemId, updateFulfillmentOrderItem.sellerFulfillmentOrderItemId) && Objects.equals(this.quantity, updateFulfillmentOrderItem.quantity) && Objects.equals(this.giftMessage, updateFulfillmentOrderItem.giftMessage) && Objects.equals(this.displayableComment, updateFulfillmentOrderItem.displayableComment) && Objects.equals(this.fulfillmentNetworkSku, updateFulfillmentOrderItem.fulfillmentNetworkSku) && Objects.equals(this.orderItemDisposition, updateFulfillmentOrderItem.orderItemDisposition) && Objects.equals(this.perUnitDeclaredValue, updateFulfillmentOrderItem.perUnitDeclaredValue) && Objects.equals(this.perUnitPrice, updateFulfillmentOrderItem.perUnitPrice) && Objects.equals(this.perUnitTax, updateFulfillmentOrderItem.perUnitTax);
    }

    public int hashCode() {
        return Objects.hash(this.sellerSku, this.sellerFulfillmentOrderItemId, this.quantity, this.giftMessage, this.displayableComment, this.fulfillmentNetworkSku, this.orderItemDisposition, this.perUnitDeclaredValue, this.perUnitPrice, this.perUnitTax);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateFulfillmentOrderItem {\n");
        sb.append("    sellerSku: ").append(this.toIndentedString(this.sellerSku)).append("\n");
        sb.append("    sellerFulfillmentOrderItemId: ").append(this.toIndentedString(this.sellerFulfillmentOrderItemId)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    giftMessage: ").append(this.toIndentedString(this.giftMessage)).append("\n");
        sb.append("    displayableComment: ").append(this.toIndentedString(this.displayableComment)).append("\n");
        sb.append("    fulfillmentNetworkSku: ").append(this.toIndentedString(this.fulfillmentNetworkSku)).append("\n");
        sb.append("    orderItemDisposition: ").append(this.toIndentedString(this.orderItemDisposition)).append("\n");
        sb.append("    perUnitDeclaredValue: ").append(this.toIndentedString(this.perUnitDeclaredValue)).append("\n");
        sb.append("    perUnitPrice: ").append(this.toIndentedString(this.perUnitPrice)).append("\n");
        sb.append("    perUnitTax: ").append(this.toIndentedString(this.perUnitTax)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

