/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fulfillmentoutbound;

import com.amazon.spapi.model.fulfillmentoutbound.StringList;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Information about unfulfillable items in a fulfillment order preview.")
public class UnfulfillablePreviewItem {
    @SerializedName(value="sellerSku")
    private String sellerSku = null;
    @SerializedName(value="quantity")
    private Integer quantity = null;
    @SerializedName(value="sellerFulfillmentOrderItemId")
    private String sellerFulfillmentOrderItemId = null;
    @SerializedName(value="itemUnfulfillableReasons")
    private StringList itemUnfulfillableReasons = null;

    public UnfulfillablePreviewItem sellerSku(String sellerSku) {
        this.sellerSku = sellerSku;
        return this;
    }

    @ApiModelProperty(required=true, value="The seller SKU of the item.")
    public String getSellerSku() {
        return this.sellerSku;
    }

    public void setSellerSku(String sellerSku) {
        this.sellerSku = sellerSku;
    }

    public UnfulfillablePreviewItem quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public UnfulfillablePreviewItem sellerFulfillmentOrderItemId(String sellerFulfillmentOrderItemId) {
        this.sellerFulfillmentOrderItemId = sellerFulfillmentOrderItemId;
        return this;
    }

    @ApiModelProperty(required=true, value="A fulfillment order item identifier created with a call to the getFulfillmentPreview operation.")
    public String getSellerFulfillmentOrderItemId() {
        return this.sellerFulfillmentOrderItemId;
    }

    public void setSellerFulfillmentOrderItemId(String sellerFulfillmentOrderItemId) {
        this.sellerFulfillmentOrderItemId = sellerFulfillmentOrderItemId;
    }

    public UnfulfillablePreviewItem itemUnfulfillableReasons(StringList itemUnfulfillableReasons) {
        this.itemUnfulfillableReasons = itemUnfulfillableReasons;
        return this;
    }

    @ApiModelProperty(value="Error codes associated with the fulfillment order preview that indicate why the item is unfulfillable.")
    public StringList getItemUnfulfillableReasons() {
        return this.itemUnfulfillableReasons;
    }

    public void setItemUnfulfillableReasons(StringList itemUnfulfillableReasons) {
        this.itemUnfulfillableReasons = itemUnfulfillableReasons;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnfulfillablePreviewItem unfulfillablePreviewItem = (UnfulfillablePreviewItem)o;
        return Objects.equals(this.sellerSku, unfulfillablePreviewItem.sellerSku) && Objects.equals(this.quantity, unfulfillablePreviewItem.quantity) && Objects.equals(this.sellerFulfillmentOrderItemId, unfulfillablePreviewItem.sellerFulfillmentOrderItemId) && Objects.equals(this.itemUnfulfillableReasons, unfulfillablePreviewItem.itemUnfulfillableReasons);
    }

    public int hashCode() {
        return Objects.hash(this.sellerSku, this.quantity, this.sellerFulfillmentOrderItemId, this.itemUnfulfillableReasons);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UnfulfillablePreviewItem {\n");
        sb.append("    sellerSku: ").append(this.toIndentedString(this.sellerSku)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    sellerFulfillmentOrderItemId: ").append(this.toIndentedString(this.sellerFulfillmentOrderItemId)).append("\n");
        sb.append("    itemUnfulfillableReasons: ").append(this.toIndentedString(this.itemUnfulfillableReasons)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

