/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fulfillmentoutbound;

import com.amazon.spapi.model.fulfillmentoutbound.Address;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Return authorization information for items accepted for return.")
public class ReturnAuthorization {
    @SerializedName(value="returnAuthorizationId")
    private String returnAuthorizationId = null;
    @SerializedName(value="fulfillmentCenterId")
    private String fulfillmentCenterId = null;
    @SerializedName(value="returnToAddress")
    private Address returnToAddress = null;
    @SerializedName(value="amazonRmaId")
    private String amazonRmaId = null;
    @SerializedName(value="rmaPageURL")
    private String rmaPageURL = null;

    public ReturnAuthorization returnAuthorizationId(String returnAuthorizationId) {
        this.returnAuthorizationId = returnAuthorizationId;
        return this;
    }

    @ApiModelProperty(required=true, value="An identifier for the return authorization. This identifier associates return items with the return authorization used to return them.")
    public String getReturnAuthorizationId() {
        return this.returnAuthorizationId;
    }

    public void setReturnAuthorizationId(String returnAuthorizationId) {
        this.returnAuthorizationId = returnAuthorizationId;
    }

    public ReturnAuthorization fulfillmentCenterId(String fulfillmentCenterId) {
        this.fulfillmentCenterId = fulfillmentCenterId;
        return this;
    }

    @ApiModelProperty(required=true, value="An identifier for the Amazon fulfillment center that the return items should be sent to.")
    public String getFulfillmentCenterId() {
        return this.fulfillmentCenterId;
    }

    public void setFulfillmentCenterId(String fulfillmentCenterId) {
        this.fulfillmentCenterId = fulfillmentCenterId;
    }

    public ReturnAuthorization returnToAddress(Address returnToAddress) {
        this.returnToAddress = returnToAddress;
        return this;
    }

    @ApiModelProperty(required=true, value="The address of the Amazon fulfillment center that the return items should be sent to.")
    public Address getReturnToAddress() {
        return this.returnToAddress;
    }

    public void setReturnToAddress(Address returnToAddress) {
        this.returnToAddress = returnToAddress;
    }

    public ReturnAuthorization amazonRmaId(String amazonRmaId) {
        this.amazonRmaId = amazonRmaId;
        return this;
    }

    @ApiModelProperty(required=true, value="The return merchandise authorization (RMA) that Amazon needs to process the return.")
    public String getAmazonRmaId() {
        return this.amazonRmaId;
    }

    public void setAmazonRmaId(String amazonRmaId) {
        this.amazonRmaId = amazonRmaId;
    }

    public ReturnAuthorization rmaPageURL(String rmaPageURL) {
        this.rmaPageURL = rmaPageURL;
        return this;
    }

    @ApiModelProperty(required=true, value="A URL for a web page that contains the return authorization barcode and the mailing label. This does not include pre-paid shipping.")
    public String getRmaPageURL() {
        return this.rmaPageURL;
    }

    public void setRmaPageURL(String rmaPageURL) {
        this.rmaPageURL = rmaPageURL;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReturnAuthorization returnAuthorization = (ReturnAuthorization)o;
        return Objects.equals(this.returnAuthorizationId, returnAuthorization.returnAuthorizationId) && Objects.equals(this.fulfillmentCenterId, returnAuthorization.fulfillmentCenterId) && Objects.equals(this.returnToAddress, returnAuthorization.returnToAddress) && Objects.equals(this.amazonRmaId, returnAuthorization.amazonRmaId) && Objects.equals(this.rmaPageURL, returnAuthorization.rmaPageURL);
    }

    public int hashCode() {
        return Objects.hash(this.returnAuthorizationId, this.fulfillmentCenterId, this.returnToAddress, this.amazonRmaId, this.rmaPageURL);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReturnAuthorization {\n");
        sb.append("    returnAuthorizationId: ").append(this.toIndentedString(this.returnAuthorizationId)).append("\n");
        sb.append("    fulfillmentCenterId: ").append(this.toIndentedString(this.fulfillmentCenterId)).append("\n");
        sb.append("    returnToAddress: ").append(this.toIndentedString(this.returnToAddress)).append("\n");
        sb.append("    amazonRmaId: ").append(this.toIndentedString(this.amazonRmaId)).append("\n");
        sb.append("    rmaPageURL: ").append(this.toIndentedString(this.rmaPageURL)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

