/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fulfillmentoutbound;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Package information for a shipment in a fulfillment order.")
public class FulfillmentShipmentPackage {
    @SerializedName(value="packageNumber")
    private Integer packageNumber = null;
    @SerializedName(value="carrierCode")
    private String carrierCode = null;
    @SerializedName(value="trackingNumber")
    private String trackingNumber = null;
    @SerializedName(value="estimatedArrivalDate")
    private String estimatedArrivalDate = null;

    public FulfillmentShipmentPackage packageNumber(Integer packageNumber) {
        this.packageNumber = packageNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="Identifies a package in a shipment.")
    public Integer getPackageNumber() {
        return this.packageNumber;
    }

    public void setPackageNumber(Integer packageNumber) {
        this.packageNumber = packageNumber;
    }

    public FulfillmentShipmentPackage carrierCode(String carrierCode) {
        this.carrierCode = carrierCode;
        return this;
    }

    @ApiModelProperty(required=true, value="Identifies the carrier who will deliver the shipment to the recipient.")
    public String getCarrierCode() {
        return this.carrierCode;
    }

    public void setCarrierCode(String carrierCode) {
        this.carrierCode = carrierCode;
    }

    public FulfillmentShipmentPackage trackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
        return this;
    }

    @ApiModelProperty(value="The tracking number, if provided, can be used to obtain tracking and delivery information.")
    public String getTrackingNumber() {
        return this.trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public FulfillmentShipmentPackage estimatedArrivalDate(String estimatedArrivalDate) {
        this.estimatedArrivalDate = estimatedArrivalDate;
        return this;
    }

    @ApiModelProperty(value="The estimated arrival date and time of the package, in ISO 8601 date time format.")
    public String getEstimatedArrivalDate() {
        return this.estimatedArrivalDate;
    }

    public void setEstimatedArrivalDate(String estimatedArrivalDate) {
        this.estimatedArrivalDate = estimatedArrivalDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FulfillmentShipmentPackage fulfillmentShipmentPackage = (FulfillmentShipmentPackage)o;
        return Objects.equals(this.packageNumber, fulfillmentShipmentPackage.packageNumber) && Objects.equals(this.carrierCode, fulfillmentShipmentPackage.carrierCode) && Objects.equals(this.trackingNumber, fulfillmentShipmentPackage.trackingNumber) && Objects.equals(this.estimatedArrivalDate, fulfillmentShipmentPackage.estimatedArrivalDate);
    }

    public int hashCode() {
        return Objects.hash(this.packageNumber, this.carrierCode, this.trackingNumber, this.estimatedArrivalDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FulfillmentShipmentPackage {\n");
        sb.append("    packageNumber: ").append(this.toIndentedString(this.packageNumber)).append("\n");
        sb.append("    carrierCode: ").append(this.toIndentedString(this.carrierCode)).append("\n");
        sb.append("    trackingNumber: ").append(this.toIndentedString(this.trackingNumber)).append("\n");
        sb.append("    estimatedArrivalDate: ").append(this.toIndentedString(this.estimatedArrivalDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

