/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fulfillmentoutbound;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Item information for a shipment in a fulfillment order.")
public class FulfillmentShipmentItem {
    @SerializedName(value="sellerSku")
    private String sellerSku = null;
    @SerializedName(value="sellerFulfillmentOrderItemId")
    private String sellerFulfillmentOrderItemId = null;
    @SerializedName(value="quantity")
    private Integer quantity = null;
    @SerializedName(value="packageNumber")
    private Integer packageNumber = null;
    @SerializedName(value="serialNumber")
    private String serialNumber = null;

    public FulfillmentShipmentItem sellerSku(String sellerSku) {
        this.sellerSku = sellerSku;
        return this;
    }

    @ApiModelProperty(required=true, value="The seller SKU of the item.")
    public String getSellerSku() {
        return this.sellerSku;
    }

    public void setSellerSku(String sellerSku) {
        this.sellerSku = sellerSku;
    }

    public FulfillmentShipmentItem sellerFulfillmentOrderItemId(String sellerFulfillmentOrderItemId) {
        this.sellerFulfillmentOrderItemId = sellerFulfillmentOrderItemId;
        return this;
    }

    @ApiModelProperty(required=true, value="The fulfillment order item identifier that the seller created and submitted with a call to the createFulfillmentOrder operation.")
    public String getSellerFulfillmentOrderItemId() {
        return this.sellerFulfillmentOrderItemId;
    }

    public void setSellerFulfillmentOrderItemId(String sellerFulfillmentOrderItemId) {
        this.sellerFulfillmentOrderItemId = sellerFulfillmentOrderItemId;
    }

    public FulfillmentShipmentItem quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public FulfillmentShipmentItem packageNumber(Integer packageNumber) {
        this.packageNumber = packageNumber;
        return this;
    }

    @ApiModelProperty(value="An identifier for the package that contains the item quantity.")
    public Integer getPackageNumber() {
        return this.packageNumber;
    }

    public void setPackageNumber(Integer packageNumber) {
        this.packageNumber = packageNumber;
    }

    public FulfillmentShipmentItem serialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    @ApiModelProperty(value="The serial number of the shipped item.")
    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FulfillmentShipmentItem fulfillmentShipmentItem = (FulfillmentShipmentItem)o;
        return Objects.equals(this.sellerSku, fulfillmentShipmentItem.sellerSku) && Objects.equals(this.sellerFulfillmentOrderItemId, fulfillmentShipmentItem.sellerFulfillmentOrderItemId) && Objects.equals(this.quantity, fulfillmentShipmentItem.quantity) && Objects.equals(this.packageNumber, fulfillmentShipmentItem.packageNumber) && Objects.equals(this.serialNumber, fulfillmentShipmentItem.serialNumber);
    }

    public int hashCode() {
        return Objects.hash(this.sellerSku, this.sellerFulfillmentOrderItemId, this.quantity, this.packageNumber, this.serialNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FulfillmentShipmentItem {\n");
        sb.append("    sellerSku: ").append(this.toIndentedString(this.sellerSku)).append("\n");
        sb.append("    sellerFulfillmentOrderItemId: ").append(this.toIndentedString(this.sellerFulfillmentOrderItemId)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    packageNumber: ").append(this.toIndentedString(this.packageNumber)).append("\n");
        sb.append("    serialNumber: ").append(this.toIndentedString(this.serialNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

