/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fulfillmentoutbound;

import com.amazon.spapi.model.fulfillmentoutbound.Money;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Item information for a fulfillment order.")
public class FulfillmentOrderItem {
    @SerializedName(value="sellerSku")
    private String sellerSku = null;
    @SerializedName(value="sellerFulfillmentOrderItemId")
    private String sellerFulfillmentOrderItemId = null;
    @SerializedName(value="quantity")
    private Integer quantity = null;
    @SerializedName(value="giftMessage")
    private String giftMessage = null;
    @SerializedName(value="displayableComment")
    private String displayableComment = null;
    @SerializedName(value="fulfillmentNetworkSku")
    private String fulfillmentNetworkSku = null;
    @SerializedName(value="orderItemDisposition")
    private String orderItemDisposition = null;
    @SerializedName(value="cancelledQuantity")
    private Integer cancelledQuantity = null;
    @SerializedName(value="unfulfillableQuantity")
    private Integer unfulfillableQuantity = null;
    @SerializedName(value="estimatedShipDate")
    private String estimatedShipDate = null;
    @SerializedName(value="estimatedArrivalDate")
    private String estimatedArrivalDate = null;
    @SerializedName(value="perUnitPrice")
    private Money perUnitPrice = null;
    @SerializedName(value="perUnitTax")
    private Money perUnitTax = null;
    @SerializedName(value="perUnitDeclaredValue")
    private Money perUnitDeclaredValue = null;

    public FulfillmentOrderItem sellerSku(String sellerSku) {
        this.sellerSku = sellerSku;
        return this;
    }

    @ApiModelProperty(required=true, value="The seller SKU of the item.")
    public String getSellerSku() {
        return this.sellerSku;
    }

    public void setSellerSku(String sellerSku) {
        this.sellerSku = sellerSku;
    }

    public FulfillmentOrderItem sellerFulfillmentOrderItemId(String sellerFulfillmentOrderItemId) {
        this.sellerFulfillmentOrderItemId = sellerFulfillmentOrderItemId;
        return this;
    }

    @ApiModelProperty(required=true, value="A fulfillment order item identifier submitted with a call to the createFulfillmentOrder operation.")
    public String getSellerFulfillmentOrderItemId() {
        return this.sellerFulfillmentOrderItemId;
    }

    public void setSellerFulfillmentOrderItemId(String sellerFulfillmentOrderItemId) {
        this.sellerFulfillmentOrderItemId = sellerFulfillmentOrderItemId;
    }

    public FulfillmentOrderItem quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public FulfillmentOrderItem giftMessage(String giftMessage) {
        this.giftMessage = giftMessage;
        return this;
    }

    @ApiModelProperty(value="A message to the gift recipient, if applicable.")
    public String getGiftMessage() {
        return this.giftMessage;
    }

    public void setGiftMessage(String giftMessage) {
        this.giftMessage = giftMessage;
    }

    public FulfillmentOrderItem displayableComment(String displayableComment) {
        this.displayableComment = displayableComment;
        return this;
    }

    @ApiModelProperty(value="Item-specific text that displays in recipient-facing materials such as the outbound shipment packing slip.")
    public String getDisplayableComment() {
        return this.displayableComment;
    }

    public void setDisplayableComment(String displayableComment) {
        this.displayableComment = displayableComment;
    }

    public FulfillmentOrderItem fulfillmentNetworkSku(String fulfillmentNetworkSku) {
        this.fulfillmentNetworkSku = fulfillmentNetworkSku;
        return this;
    }

    @ApiModelProperty(value="Amazon's fulfillment network SKU of the item.")
    public String getFulfillmentNetworkSku() {
        return this.fulfillmentNetworkSku;
    }

    public void setFulfillmentNetworkSku(String fulfillmentNetworkSku) {
        this.fulfillmentNetworkSku = fulfillmentNetworkSku;
    }

    public FulfillmentOrderItem orderItemDisposition(String orderItemDisposition) {
        this.orderItemDisposition = orderItemDisposition;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the item is sellable or unsellable.")
    public String getOrderItemDisposition() {
        return this.orderItemDisposition;
    }

    public void setOrderItemDisposition(String orderItemDisposition) {
        this.orderItemDisposition = orderItemDisposition;
    }

    public FulfillmentOrderItem cancelledQuantity(Integer cancelledQuantity) {
        this.cancelledQuantity = cancelledQuantity;
        return this;
    }

    @ApiModelProperty(required=true, value="The item quantity that was cancelled by the seller.")
    public Integer getCancelledQuantity() {
        return this.cancelledQuantity;
    }

    public void setCancelledQuantity(Integer cancelledQuantity) {
        this.cancelledQuantity = cancelledQuantity;
    }

    public FulfillmentOrderItem unfulfillableQuantity(Integer unfulfillableQuantity) {
        this.unfulfillableQuantity = unfulfillableQuantity;
        return this;
    }

    @ApiModelProperty(required=true, value="The item quantity that is unfulfillable.")
    public Integer getUnfulfillableQuantity() {
        return this.unfulfillableQuantity;
    }

    public void setUnfulfillableQuantity(Integer unfulfillableQuantity) {
        this.unfulfillableQuantity = unfulfillableQuantity;
    }

    public FulfillmentOrderItem estimatedShipDate(String estimatedShipDate) {
        this.estimatedShipDate = estimatedShipDate;
        return this;
    }

    @ApiModelProperty(value="The estimated date and time that the item quantity is scheduled to ship from the fulfillment center. Note that this value can change over time. If the shipment that contains the item quantity has been cancelled, estimatedShipDate is not returned.")
    public String getEstimatedShipDate() {
        return this.estimatedShipDate;
    }

    public void setEstimatedShipDate(String estimatedShipDate) {
        this.estimatedShipDate = estimatedShipDate;
    }

    public FulfillmentOrderItem estimatedArrivalDate(String estimatedArrivalDate) {
        this.estimatedArrivalDate = estimatedArrivalDate;
        return this;
    }

    @ApiModelProperty(value="The estimated arrival date and time of the item quantity. Note that this value can change over time. If the shipment that contains the item quantity has been cancelled, estimatedArrivalDate is not returned.")
    public String getEstimatedArrivalDate() {
        return this.estimatedArrivalDate;
    }

    public void setEstimatedArrivalDate(String estimatedArrivalDate) {
        this.estimatedArrivalDate = estimatedArrivalDate;
    }

    public FulfillmentOrderItem perUnitPrice(Money perUnitPrice) {
        this.perUnitPrice = perUnitPrice;
        return this;
    }

    @ApiModelProperty(value="The amount to be collected from the recipient for this item in a COD (Cash On Delivery) order.")
    public Money getPerUnitPrice() {
        return this.perUnitPrice;
    }

    public void setPerUnitPrice(Money perUnitPrice) {
        this.perUnitPrice = perUnitPrice;
    }

    public FulfillmentOrderItem perUnitTax(Money perUnitTax) {
        this.perUnitTax = perUnitTax;
        return this;
    }

    @ApiModelProperty(value="The tax on the amount to be collected from the recipient for this item in a COD (Cash On Delivery) order.")
    public Money getPerUnitTax() {
        return this.perUnitTax;
    }

    public void setPerUnitTax(Money perUnitTax) {
        this.perUnitTax = perUnitTax;
    }

    public FulfillmentOrderItem perUnitDeclaredValue(Money perUnitDeclaredValue) {
        this.perUnitDeclaredValue = perUnitDeclaredValue;
        return this;
    }

    @ApiModelProperty(value="The monetary value assigned by the seller to this item.")
    public Money getPerUnitDeclaredValue() {
        return this.perUnitDeclaredValue;
    }

    public void setPerUnitDeclaredValue(Money perUnitDeclaredValue) {
        this.perUnitDeclaredValue = perUnitDeclaredValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FulfillmentOrderItem fulfillmentOrderItem = (FulfillmentOrderItem)o;
        return Objects.equals(this.sellerSku, fulfillmentOrderItem.sellerSku) && Objects.equals(this.sellerFulfillmentOrderItemId, fulfillmentOrderItem.sellerFulfillmentOrderItemId) && Objects.equals(this.quantity, fulfillmentOrderItem.quantity) && Objects.equals(this.giftMessage, fulfillmentOrderItem.giftMessage) && Objects.equals(this.displayableComment, fulfillmentOrderItem.displayableComment) && Objects.equals(this.fulfillmentNetworkSku, fulfillmentOrderItem.fulfillmentNetworkSku) && Objects.equals(this.orderItemDisposition, fulfillmentOrderItem.orderItemDisposition) && Objects.equals(this.cancelledQuantity, fulfillmentOrderItem.cancelledQuantity) && Objects.equals(this.unfulfillableQuantity, fulfillmentOrderItem.unfulfillableQuantity) && Objects.equals(this.estimatedShipDate, fulfillmentOrderItem.estimatedShipDate) && Objects.equals(this.estimatedArrivalDate, fulfillmentOrderItem.estimatedArrivalDate) && Objects.equals(this.perUnitPrice, fulfillmentOrderItem.perUnitPrice) && Objects.equals(this.perUnitTax, fulfillmentOrderItem.perUnitTax) && Objects.equals(this.perUnitDeclaredValue, fulfillmentOrderItem.perUnitDeclaredValue);
    }

    public int hashCode() {
        return Objects.hash(this.sellerSku, this.sellerFulfillmentOrderItemId, this.quantity, this.giftMessage, this.displayableComment, this.fulfillmentNetworkSku, this.orderItemDisposition, this.cancelledQuantity, this.unfulfillableQuantity, this.estimatedShipDate, this.estimatedArrivalDate, this.perUnitPrice, this.perUnitTax, this.perUnitDeclaredValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FulfillmentOrderItem {\n");
        sb.append("    sellerSku: ").append(this.toIndentedString(this.sellerSku)).append("\n");
        sb.append("    sellerFulfillmentOrderItemId: ").append(this.toIndentedString(this.sellerFulfillmentOrderItemId)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    giftMessage: ").append(this.toIndentedString(this.giftMessage)).append("\n");
        sb.append("    displayableComment: ").append(this.toIndentedString(this.displayableComment)).append("\n");
        sb.append("    fulfillmentNetworkSku: ").append(this.toIndentedString(this.fulfillmentNetworkSku)).append("\n");
        sb.append("    orderItemDisposition: ").append(this.toIndentedString(this.orderItemDisposition)).append("\n");
        sb.append("    cancelledQuantity: ").append(this.toIndentedString(this.cancelledQuantity)).append("\n");
        sb.append("    unfulfillableQuantity: ").append(this.toIndentedString(this.unfulfillableQuantity)).append("\n");
        sb.append("    estimatedShipDate: ").append(this.toIndentedString(this.estimatedShipDate)).append("\n");
        sb.append("    estimatedArrivalDate: ").append(this.toIndentedString(this.estimatedArrivalDate)).append("\n");
        sb.append("    perUnitPrice: ").append(this.toIndentedString(this.perUnitPrice)).append("\n");
        sb.append("    perUnitTax: ").append(this.toIndentedString(this.perUnitTax)).append("\n");
        sb.append("    perUnitDeclaredValue: ").append(this.toIndentedString(this.perUnitDeclaredValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

