/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fulfillmentoutbound;

import com.amazon.spapi.model.fulfillmentoutbound.Address;
import com.amazon.spapi.model.fulfillmentoutbound.CODSettings;
import com.amazon.spapi.model.fulfillmentoutbound.DeliveryWindow;
import com.amazon.spapi.model.fulfillmentoutbound.FeatureSettings;
import com.amazon.spapi.model.fulfillmentoutbound.FulfillmentAction;
import com.amazon.spapi.model.fulfillmentoutbound.FulfillmentOrderStatus;
import com.amazon.spapi.model.fulfillmentoutbound.FulfillmentPolicy;
import com.amazon.spapi.model.fulfillmentoutbound.NotificationEmailList;
import com.amazon.spapi.model.fulfillmentoutbound.ShippingSpeedCategory;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="General information about a fulfillment order, including its status.")
public class FulfillmentOrder {
    @SerializedName(value="sellerFulfillmentOrderId")
    private String sellerFulfillmentOrderId = null;
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="displayableOrderId")
    private String displayableOrderId = null;
    @SerializedName(value="displayableOrderDate")
    private String displayableOrderDate = null;
    @SerializedName(value="displayableOrderComment")
    private String displayableOrderComment = null;
    @SerializedName(value="shippingSpeedCategory")
    private ShippingSpeedCategory shippingSpeedCategory = null;
    @SerializedName(value="deliveryWindow")
    private DeliveryWindow deliveryWindow = null;
    @SerializedName(value="destinationAddress")
    private Address destinationAddress = null;
    @SerializedName(value="fulfillmentAction")
    private FulfillmentAction fulfillmentAction = null;
    @SerializedName(value="fulfillmentPolicy")
    private FulfillmentPolicy fulfillmentPolicy = null;
    @SerializedName(value="codSettings")
    private CODSettings codSettings = null;
    @SerializedName(value="receivedDate")
    private String receivedDate = null;
    @SerializedName(value="fulfillmentOrderStatus")
    private FulfillmentOrderStatus fulfillmentOrderStatus = null;
    @SerializedName(value="statusUpdatedDate")
    private String statusUpdatedDate = null;
    @SerializedName(value="notificationEmails")
    private NotificationEmailList notificationEmails = null;
    @SerializedName(value="featureConstraints")
    private List<FeatureSettings> featureConstraints = null;

    public FulfillmentOrder sellerFulfillmentOrderId(String sellerFulfillmentOrderId) {
        this.sellerFulfillmentOrderId = sellerFulfillmentOrderId;
        return this;
    }

    @ApiModelProperty(required=true, value="The fulfillment order identifier submitted with the createFulfillmentOrder operation.")
    public String getSellerFulfillmentOrderId() {
        return this.sellerFulfillmentOrderId;
    }

    public void setSellerFulfillmentOrderId(String sellerFulfillmentOrderId) {
        this.sellerFulfillmentOrderId = sellerFulfillmentOrderId;
    }

    public FulfillmentOrder marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @ApiModelProperty(required=true, value="The identifier for the marketplace the fulfillment order is placed against.")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public FulfillmentOrder displayableOrderId(String displayableOrderId) {
        this.displayableOrderId = displayableOrderId;
        return this;
    }

    @ApiModelProperty(required=true, value="A fulfillment order identifier submitted with the createFulfillmentOrder operation. Displays as the order identifier in recipient-facing materials such as the packing slip.")
    public String getDisplayableOrderId() {
        return this.displayableOrderId;
    }

    public void setDisplayableOrderId(String displayableOrderId) {
        this.displayableOrderId = displayableOrderId;
    }

    public FulfillmentOrder displayableOrderDate(String displayableOrderDate) {
        this.displayableOrderDate = displayableOrderDate;
        return this;
    }

    @ApiModelProperty(required=true, value="A date and time submitted with the createFulfillmentOrder operation. Displays as the order date in recipient-facing materials such as the packing slip.")
    public String getDisplayableOrderDate() {
        return this.displayableOrderDate;
    }

    public void setDisplayableOrderDate(String displayableOrderDate) {
        this.displayableOrderDate = displayableOrderDate;
    }

    public FulfillmentOrder displayableOrderComment(String displayableOrderComment) {
        this.displayableOrderComment = displayableOrderComment;
        return this;
    }

    @ApiModelProperty(required=true, value="A text block submitted with the createFulfillmentOrder operation. Displays in recipient-facing materials such as the packing slip.")
    public String getDisplayableOrderComment() {
        return this.displayableOrderComment;
    }

    public void setDisplayableOrderComment(String displayableOrderComment) {
        this.displayableOrderComment = displayableOrderComment;
    }

    public FulfillmentOrder shippingSpeedCategory(ShippingSpeedCategory shippingSpeedCategory) {
        this.shippingSpeedCategory = shippingSpeedCategory;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ShippingSpeedCategory getShippingSpeedCategory() {
        return this.shippingSpeedCategory;
    }

    public void setShippingSpeedCategory(ShippingSpeedCategory shippingSpeedCategory) {
        this.shippingSpeedCategory = shippingSpeedCategory;
    }

    public FulfillmentOrder deliveryWindow(DeliveryWindow deliveryWindow) {
        this.deliveryWindow = deliveryWindow;
        return this;
    }

    @ApiModelProperty(value="")
    public DeliveryWindow getDeliveryWindow() {
        return this.deliveryWindow;
    }

    public void setDeliveryWindow(DeliveryWindow deliveryWindow) {
        this.deliveryWindow = deliveryWindow;
    }

    public FulfillmentOrder destinationAddress(Address destinationAddress) {
        this.destinationAddress = destinationAddress;
        return this;
    }

    @ApiModelProperty(required=true, value="The destination address submitted with the createFulfillmentOrder operation.")
    public Address getDestinationAddress() {
        return this.destinationAddress;
    }

    public void setDestinationAddress(Address destinationAddress) {
        this.destinationAddress = destinationAddress;
    }

    public FulfillmentOrder fulfillmentAction(FulfillmentAction fulfillmentAction) {
        this.fulfillmentAction = fulfillmentAction;
        return this;
    }

    @ApiModelProperty(value="")
    public FulfillmentAction getFulfillmentAction() {
        return this.fulfillmentAction;
    }

    public void setFulfillmentAction(FulfillmentAction fulfillmentAction) {
        this.fulfillmentAction = fulfillmentAction;
    }

    public FulfillmentOrder fulfillmentPolicy(FulfillmentPolicy fulfillmentPolicy) {
        this.fulfillmentPolicy = fulfillmentPolicy;
        return this;
    }

    @ApiModelProperty(value="")
    public FulfillmentPolicy getFulfillmentPolicy() {
        return this.fulfillmentPolicy;
    }

    public void setFulfillmentPolicy(FulfillmentPolicy fulfillmentPolicy) {
        this.fulfillmentPolicy = fulfillmentPolicy;
    }

    public FulfillmentOrder codSettings(CODSettings codSettings) {
        this.codSettings = codSettings;
        return this;
    }

    @ApiModelProperty(value="")
    public CODSettings getCodSettings() {
        return this.codSettings;
    }

    public void setCodSettings(CODSettings codSettings) {
        this.codSettings = codSettings;
    }

    public FulfillmentOrder receivedDate(String receivedDate) {
        this.receivedDate = receivedDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The date and time that the fulfillment order was received by an Amazon fulfillment center.")
    public String getReceivedDate() {
        return this.receivedDate;
    }

    public void setReceivedDate(String receivedDate) {
        this.receivedDate = receivedDate;
    }

    public FulfillmentOrder fulfillmentOrderStatus(FulfillmentOrderStatus fulfillmentOrderStatus) {
        this.fulfillmentOrderStatus = fulfillmentOrderStatus;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public FulfillmentOrderStatus getFulfillmentOrderStatus() {
        return this.fulfillmentOrderStatus;
    }

    public void setFulfillmentOrderStatus(FulfillmentOrderStatus fulfillmentOrderStatus) {
        this.fulfillmentOrderStatus = fulfillmentOrderStatus;
    }

    public FulfillmentOrder statusUpdatedDate(String statusUpdatedDate) {
        this.statusUpdatedDate = statusUpdatedDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The date and time that the status of the fulfillment order last changed, in ISO 8601 date time format.")
    public String getStatusUpdatedDate() {
        return this.statusUpdatedDate;
    }

    public void setStatusUpdatedDate(String statusUpdatedDate) {
        this.statusUpdatedDate = statusUpdatedDate;
    }

    public FulfillmentOrder notificationEmails(NotificationEmailList notificationEmails) {
        this.notificationEmails = notificationEmails;
        return this;
    }

    @ApiModelProperty(value="")
    public NotificationEmailList getNotificationEmails() {
        return this.notificationEmails;
    }

    public void setNotificationEmails(NotificationEmailList notificationEmails) {
        this.notificationEmails = notificationEmails;
    }

    public FulfillmentOrder featureConstraints(List<FeatureSettings> featureConstraints) {
        this.featureConstraints = featureConstraints;
        return this;
    }

    public FulfillmentOrder addFeatureConstraintsItem(FeatureSettings featureConstraintsItem) {
        if (this.featureConstraints == null) {
            this.featureConstraints = new ArrayList<FeatureSettings>();
        }
        this.featureConstraints.add(featureConstraintsItem);
        return this;
    }

    @ApiModelProperty(value="A list of features and their fulfillment policies to apply to the order.")
    public List<FeatureSettings> getFeatureConstraints() {
        return this.featureConstraints;
    }

    public void setFeatureConstraints(List<FeatureSettings> featureConstraints) {
        this.featureConstraints = featureConstraints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FulfillmentOrder fulfillmentOrder = (FulfillmentOrder)o;
        return Objects.equals(this.sellerFulfillmentOrderId, fulfillmentOrder.sellerFulfillmentOrderId) && Objects.equals(this.marketplaceId, fulfillmentOrder.marketplaceId) && Objects.equals(this.displayableOrderId, fulfillmentOrder.displayableOrderId) && Objects.equals(this.displayableOrderDate, fulfillmentOrder.displayableOrderDate) && Objects.equals(this.displayableOrderComment, fulfillmentOrder.displayableOrderComment) && Objects.equals((Object)this.shippingSpeedCategory, (Object)fulfillmentOrder.shippingSpeedCategory) && Objects.equals(this.deliveryWindow, fulfillmentOrder.deliveryWindow) && Objects.equals(this.destinationAddress, fulfillmentOrder.destinationAddress) && Objects.equals((Object)this.fulfillmentAction, (Object)fulfillmentOrder.fulfillmentAction) && Objects.equals((Object)this.fulfillmentPolicy, (Object)fulfillmentOrder.fulfillmentPolicy) && Objects.equals(this.codSettings, fulfillmentOrder.codSettings) && Objects.equals(this.receivedDate, fulfillmentOrder.receivedDate) && Objects.equals((Object)this.fulfillmentOrderStatus, (Object)fulfillmentOrder.fulfillmentOrderStatus) && Objects.equals(this.statusUpdatedDate, fulfillmentOrder.statusUpdatedDate) && Objects.equals(this.notificationEmails, fulfillmentOrder.notificationEmails) && Objects.equals(this.featureConstraints, fulfillmentOrder.featureConstraints);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sellerFulfillmentOrderId, this.marketplaceId, this.displayableOrderId, this.displayableOrderDate, this.displayableOrderComment, this.shippingSpeedCategory, this.deliveryWindow, this.destinationAddress, this.fulfillmentAction, this.fulfillmentPolicy, this.codSettings, this.receivedDate, this.fulfillmentOrderStatus, this.statusUpdatedDate, this.notificationEmails, this.featureConstraints});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FulfillmentOrder {\n");
        sb.append("    sellerFulfillmentOrderId: ").append(this.toIndentedString(this.sellerFulfillmentOrderId)).append("\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    displayableOrderId: ").append(this.toIndentedString(this.displayableOrderId)).append("\n");
        sb.append("    displayableOrderDate: ").append(this.toIndentedString(this.displayableOrderDate)).append("\n");
        sb.append("    displayableOrderComment: ").append(this.toIndentedString(this.displayableOrderComment)).append("\n");
        sb.append("    shippingSpeedCategory: ").append(this.toIndentedString((Object)this.shippingSpeedCategory)).append("\n");
        sb.append("    deliveryWindow: ").append(this.toIndentedString(this.deliveryWindow)).append("\n");
        sb.append("    destinationAddress: ").append(this.toIndentedString(this.destinationAddress)).append("\n");
        sb.append("    fulfillmentAction: ").append(this.toIndentedString((Object)this.fulfillmentAction)).append("\n");
        sb.append("    fulfillmentPolicy: ").append(this.toIndentedString((Object)this.fulfillmentPolicy)).append("\n");
        sb.append("    codSettings: ").append(this.toIndentedString(this.codSettings)).append("\n");
        sb.append("    receivedDate: ").append(this.toIndentedString(this.receivedDate)).append("\n");
        sb.append("    fulfillmentOrderStatus: ").append(this.toIndentedString((Object)this.fulfillmentOrderStatus)).append("\n");
        sb.append("    statusUpdatedDate: ").append(this.toIndentedString(this.statusUpdatedDate)).append("\n");
        sb.append("    notificationEmails: ").append(this.toIndentedString(this.notificationEmails)).append("\n");
        sb.append("    featureConstraints: ").append(this.toIndentedString(this.featureConstraints)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

