/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fulfillmentoutbound;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Settings to apply to an order that includes the specified fulfillment feature.")
public class FeatureSettings {
    @SerializedName(value="featureName")
    private String featureName = null;
    @SerializedName(value="featureFulfillmentPolicy")
    private FeatureFulfillmentPolicyEnum featureFulfillmentPolicy = null;

    public FeatureSettings featureName(String featureName) {
        this.featureName = featureName;
        return this;
    }

    @ApiModelProperty(value="The name of the feature.")
    public String getFeatureName() {
        return this.featureName;
    }

    public void setFeatureName(String featureName) {
        this.featureName = featureName;
    }

    public FeatureSettings featureFulfillmentPolicy(FeatureFulfillmentPolicyEnum featureFulfillmentPolicy) {
        this.featureFulfillmentPolicy = featureFulfillmentPolicy;
        return this;
    }

    @ApiModelProperty(value="Specifies the policy to use when fulfilling an order.")
    public FeatureFulfillmentPolicyEnum getFeatureFulfillmentPolicy() {
        return this.featureFulfillmentPolicy;
    }

    public void setFeatureFulfillmentPolicy(FeatureFulfillmentPolicyEnum featureFulfillmentPolicy) {
        this.featureFulfillmentPolicy = featureFulfillmentPolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureSettings featureSettings = (FeatureSettings)o;
        return Objects.equals(this.featureName, featureSettings.featureName) && Objects.equals((Object)this.featureFulfillmentPolicy, (Object)featureSettings.featureFulfillmentPolicy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.featureName, this.featureFulfillmentPolicy});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeatureSettings {\n");
        sb.append("    featureName: ").append(this.toIndentedString(this.featureName)).append("\n");
        sb.append("    featureFulfillmentPolicy: ").append(this.toIndentedString((Object)this.featureFulfillmentPolicy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FeatureFulfillmentPolicyEnum {
        REQUIRED("Required"),
        NOTREQUIRED("NotRequired");

        private String value;

        private FeatureFulfillmentPolicyEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FeatureFulfillmentPolicyEnum fromValue(String text) {
            for (FeatureFulfillmentPolicyEnum b : FeatureFulfillmentPolicyEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<FeatureFulfillmentPolicyEnum> {
            public void write(JsonWriter jsonWriter, FeatureFulfillmentPolicyEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FeatureFulfillmentPolicyEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FeatureFulfillmentPolicyEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

