/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fulfillmentoutbound;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The time range within which a Scheduled Delivery fulfillment order should be delivered.")
public class DeliveryWindow {
    @SerializedName(value="startDate")
    private String startDate = null;
    @SerializedName(value="endDate")
    private String endDate = null;

    public DeliveryWindow startDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The date and time of the start of the Scheduled Delivery window, in ISO 8601 date time format.")
    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public DeliveryWindow endDate(String endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The date and time of the end of the Scheduled Delivery window, in ISO 8601 date time format.")
    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeliveryWindow deliveryWindow = (DeliveryWindow)o;
        return Objects.equals(this.startDate, deliveryWindow.startDate) && Objects.equals(this.endDate, deliveryWindow.endDate);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeliveryWindow {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

