/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fulfillmentinbound;

import com.amazon.spapi.model.fulfillmentinbound.Amount;
import com.amazon.spapi.model.fulfillmentinbound.Contact;
import com.amazon.spapi.model.fulfillmentinbound.PalletList;
import com.amazon.spapi.model.fulfillmentinbound.PartneredEstimate;
import com.amazon.spapi.model.fulfillmentinbound.SellerFreightClass;
import com.amazon.spapi.model.fulfillmentinbound.Weight;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Information returned by Amazon about a Less Than Truckload/Full Truckload (LTL/FTL) shipment by an Amazon-partnered carrier.")
public class PartneredLtlDataOutput {
    @SerializedName(value="Contact")
    private Contact contact = null;
    @SerializedName(value="BoxCount")
    private Integer boxCount = null;
    @SerializedName(value="SellerFreightClass")
    private SellerFreightClass sellerFreightClass = null;
    @SerializedName(value="FreightReadyDate")
    private String freightReadyDate = null;
    @SerializedName(value="PalletList")
    private PalletList palletList = null;
    @SerializedName(value="TotalWeight")
    private Weight totalWeight = null;
    @SerializedName(value="SellerDeclaredValue")
    private Amount sellerDeclaredValue = null;
    @SerializedName(value="AmazonCalculatedValue")
    private Amount amazonCalculatedValue = null;
    @SerializedName(value="PreviewPickupDate")
    private String previewPickupDate = null;
    @SerializedName(value="PreviewDeliveryDate")
    private String previewDeliveryDate = null;
    @SerializedName(value="PreviewFreightClass")
    private SellerFreightClass previewFreightClass = null;
    @SerializedName(value="AmazonReferenceId")
    private String amazonReferenceId = null;
    @SerializedName(value="IsBillOfLadingAvailable")
    private Boolean isBillOfLadingAvailable = null;
    @SerializedName(value="PartneredEstimate")
    private PartneredEstimate partneredEstimate = null;
    @SerializedName(value="CarrierName")
    private String carrierName = null;

    public PartneredLtlDataOutput contact(Contact contact) {
        this.contact = contact;
        return this;
    }

    @ApiModelProperty(required=true, value="Contact information for the person in the seller's organization who is responsible for the shipment. Used by the carrier if they have questions about the shipment.")
    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public PartneredLtlDataOutput boxCount(Integer boxCount) {
        this.boxCount = boxCount;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of boxes in the shipment.")
    public Integer getBoxCount() {
        return this.boxCount;
    }

    public void setBoxCount(Integer boxCount) {
        this.boxCount = boxCount;
    }

    public PartneredLtlDataOutput sellerFreightClass(SellerFreightClass sellerFreightClass) {
        this.sellerFreightClass = sellerFreightClass;
        return this;
    }

    @ApiModelProperty(value="")
    public SellerFreightClass getSellerFreightClass() {
        return this.sellerFreightClass;
    }

    public void setSellerFreightClass(SellerFreightClass sellerFreightClass) {
        this.sellerFreightClass = sellerFreightClass;
    }

    public PartneredLtlDataOutput freightReadyDate(String freightReadyDate) {
        this.freightReadyDate = freightReadyDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The date that the shipment will be ready to be picked up by the carrier. Must be in YYYY-MM-DD format.")
    public String getFreightReadyDate() {
        return this.freightReadyDate;
    }

    public void setFreightReadyDate(String freightReadyDate) {
        this.freightReadyDate = freightReadyDate;
    }

    public PartneredLtlDataOutput palletList(PalletList palletList) {
        this.palletList = palletList;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public PalletList getPalletList() {
        return this.palletList;
    }

    public void setPalletList(PalletList palletList) {
        this.palletList = palletList;
    }

    public PartneredLtlDataOutput totalWeight(Weight totalWeight) {
        this.totalWeight = totalWeight;
        return this;
    }

    @ApiModelProperty(required=true, value="The total weight of the shipment.")
    public Weight getTotalWeight() {
        return this.totalWeight;
    }

    public void setTotalWeight(Weight totalWeight) {
        this.totalWeight = totalWeight;
    }

    public PartneredLtlDataOutput sellerDeclaredValue(Amount sellerDeclaredValue) {
        this.sellerDeclaredValue = sellerDeclaredValue;
        return this;
    }

    @ApiModelProperty(value="Your declaration of the total value of the inventory in the shipment.")
    public Amount getSellerDeclaredValue() {
        return this.sellerDeclaredValue;
    }

    public void setSellerDeclaredValue(Amount sellerDeclaredValue) {
        this.sellerDeclaredValue = sellerDeclaredValue;
    }

    public PartneredLtlDataOutput amazonCalculatedValue(Amount amazonCalculatedValue) {
        this.amazonCalculatedValue = amazonCalculatedValue;
        return this;
    }

    @ApiModelProperty(value="Estimate by Amazon of the total value of the inventory in the shipment.")
    public Amount getAmazonCalculatedValue() {
        return this.amazonCalculatedValue;
    }

    public void setAmazonCalculatedValue(Amount amazonCalculatedValue) {
        this.amazonCalculatedValue = amazonCalculatedValue;
    }

    public PartneredLtlDataOutput previewPickupDate(String previewPickupDate) {
        this.previewPickupDate = previewPickupDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The estimated date that the shipment will be picked up by the carrier, in YYYY-MM-DD format.")
    public String getPreviewPickupDate() {
        return this.previewPickupDate;
    }

    public void setPreviewPickupDate(String previewPickupDate) {
        this.previewPickupDate = previewPickupDate;
    }

    public PartneredLtlDataOutput previewDeliveryDate(String previewDeliveryDate) {
        this.previewDeliveryDate = previewDeliveryDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The estimated date that the shipment will be delivered to an Amazon fulfillment center, in YYYY-MM-DD format.")
    public String getPreviewDeliveryDate() {
        return this.previewDeliveryDate;
    }

    public void setPreviewDeliveryDate(String previewDeliveryDate) {
        this.previewDeliveryDate = previewDeliveryDate;
    }

    public PartneredLtlDataOutput previewFreightClass(SellerFreightClass previewFreightClass) {
        this.previewFreightClass = previewFreightClass;
        return this;
    }

    @ApiModelProperty(required=true, value="The freight class of the shipment as estimated by Amazon if you did not include a freight class when you called the putTransportDetails operation.")
    public SellerFreightClass getPreviewFreightClass() {
        return this.previewFreightClass;
    }

    public void setPreviewFreightClass(SellerFreightClass previewFreightClass) {
        this.previewFreightClass = previewFreightClass;
    }

    public PartneredLtlDataOutput amazonReferenceId(String amazonReferenceId) {
        this.amazonReferenceId = amazonReferenceId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier created by Amazon that identifies this Amazon-partnered, Less Than Truckload/Full Truckload (LTL/FTL) shipment.")
    public String getAmazonReferenceId() {
        return this.amazonReferenceId;
    }

    public void setAmazonReferenceId(String amazonReferenceId) {
        this.amazonReferenceId = amazonReferenceId;
    }

    public PartneredLtlDataOutput isBillOfLadingAvailable(Boolean isBillOfLadingAvailable) {
        this.isBillOfLadingAvailable = isBillOfLadingAvailable;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether the bill of lading for the shipment is available.")
    public Boolean isIsBillOfLadingAvailable() {
        return this.isBillOfLadingAvailable;
    }

    public void setIsBillOfLadingAvailable(Boolean isBillOfLadingAvailable) {
        this.isBillOfLadingAvailable = isBillOfLadingAvailable;
    }

    public PartneredLtlDataOutput partneredEstimate(PartneredEstimate partneredEstimate) {
        this.partneredEstimate = partneredEstimate;
        return this;
    }

    @ApiModelProperty(value="The estimated shipping cost using an Amazon-partnered carrier.")
    public PartneredEstimate getPartneredEstimate() {
        return this.partneredEstimate;
    }

    public void setPartneredEstimate(PartneredEstimate partneredEstimate) {
        this.partneredEstimate = partneredEstimate;
    }

    public PartneredLtlDataOutput carrierName(String carrierName) {
        this.carrierName = carrierName;
        return this;
    }

    @ApiModelProperty(required=true, value="The carrier for the inbound shipment.")
    public String getCarrierName() {
        return this.carrierName;
    }

    public void setCarrierName(String carrierName) {
        this.carrierName = carrierName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartneredLtlDataOutput partneredLtlDataOutput = (PartneredLtlDataOutput)o;
        return Objects.equals(this.contact, partneredLtlDataOutput.contact) && Objects.equals(this.boxCount, partneredLtlDataOutput.boxCount) && Objects.equals((Object)this.sellerFreightClass, (Object)partneredLtlDataOutput.sellerFreightClass) && Objects.equals(this.freightReadyDate, partneredLtlDataOutput.freightReadyDate) && Objects.equals(this.palletList, partneredLtlDataOutput.palletList) && Objects.equals(this.totalWeight, partneredLtlDataOutput.totalWeight) && Objects.equals(this.sellerDeclaredValue, partneredLtlDataOutput.sellerDeclaredValue) && Objects.equals(this.amazonCalculatedValue, partneredLtlDataOutput.amazonCalculatedValue) && Objects.equals(this.previewPickupDate, partneredLtlDataOutput.previewPickupDate) && Objects.equals(this.previewDeliveryDate, partneredLtlDataOutput.previewDeliveryDate) && Objects.equals((Object)this.previewFreightClass, (Object)partneredLtlDataOutput.previewFreightClass) && Objects.equals(this.amazonReferenceId, partneredLtlDataOutput.amazonReferenceId) && Objects.equals(this.isBillOfLadingAvailable, partneredLtlDataOutput.isBillOfLadingAvailable) && Objects.equals(this.partneredEstimate, partneredLtlDataOutput.partneredEstimate) && Objects.equals(this.carrierName, partneredLtlDataOutput.carrierName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.contact, this.boxCount, this.sellerFreightClass, this.freightReadyDate, this.palletList, this.totalWeight, this.sellerDeclaredValue, this.amazonCalculatedValue, this.previewPickupDate, this.previewDeliveryDate, this.previewFreightClass, this.amazonReferenceId, this.isBillOfLadingAvailable, this.partneredEstimate, this.carrierName});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PartneredLtlDataOutput {\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    boxCount: ").append(this.toIndentedString(this.boxCount)).append("\n");
        sb.append("    sellerFreightClass: ").append(this.toIndentedString((Object)this.sellerFreightClass)).append("\n");
        sb.append("    freightReadyDate: ").append(this.toIndentedString(this.freightReadyDate)).append("\n");
        sb.append("    palletList: ").append(this.toIndentedString(this.palletList)).append("\n");
        sb.append("    totalWeight: ").append(this.toIndentedString(this.totalWeight)).append("\n");
        sb.append("    sellerDeclaredValue: ").append(this.toIndentedString(this.sellerDeclaredValue)).append("\n");
        sb.append("    amazonCalculatedValue: ").append(this.toIndentedString(this.amazonCalculatedValue)).append("\n");
        sb.append("    previewPickupDate: ").append(this.toIndentedString(this.previewPickupDate)).append("\n");
        sb.append("    previewDeliveryDate: ").append(this.toIndentedString(this.previewDeliveryDate)).append("\n");
        sb.append("    previewFreightClass: ").append(this.toIndentedString((Object)this.previewFreightClass)).append("\n");
        sb.append("    amazonReferenceId: ").append(this.toIndentedString(this.amazonReferenceId)).append("\n");
        sb.append("    isBillOfLadingAvailable: ").append(this.toIndentedString(this.isBillOfLadingAvailable)).append("\n");
        sb.append("    partneredEstimate: ").append(this.toIndentedString(this.partneredEstimate)).append("\n");
        sb.append("    carrierName: ").append(this.toIndentedString(this.carrierName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

