/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fulfillmentinbound;

import com.amazon.spapi.model.fulfillmentinbound.Amount;
import com.amazon.spapi.model.fulfillmentinbound.Contact;
import com.amazon.spapi.model.fulfillmentinbound.PalletList;
import com.amazon.spapi.model.fulfillmentinbound.SellerFreightClass;
import com.amazon.spapi.model.fulfillmentinbound.Weight;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Information that is required by an Amazon-partnered carrier to ship a Less Than Truckload/Full Truckload (LTL/FTL) inbound shipment.")
public class PartneredLtlDataInput {
    @SerializedName(value="Contact")
    private Contact contact = null;
    @SerializedName(value="BoxCount")
    private Integer boxCount = null;
    @SerializedName(value="SellerFreightClass")
    private SellerFreightClass sellerFreightClass = null;
    @SerializedName(value="FreightReadyDate")
    private String freightReadyDate = null;
    @SerializedName(value="PalletList")
    private PalletList palletList = null;
    @SerializedName(value="TotalWeight")
    private Weight totalWeight = null;
    @SerializedName(value="SellerDeclaredValue")
    private Amount sellerDeclaredValue = null;

    public PartneredLtlDataInput contact(Contact contact) {
        this.contact = contact;
        return this;
    }

    @ApiModelProperty(value="Contact information for the person in the seller's organization who is responsible for the shipment. Used by the carrier if they have questions about the shipment.")
    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public PartneredLtlDataInput boxCount(Integer boxCount) {
        this.boxCount = boxCount;
        return this;
    }

    @ApiModelProperty(value="The number of boxes in the shipment.")
    public Integer getBoxCount() {
        return this.boxCount;
    }

    public void setBoxCount(Integer boxCount) {
        this.boxCount = boxCount;
    }

    public PartneredLtlDataInput sellerFreightClass(SellerFreightClass sellerFreightClass) {
        this.sellerFreightClass = sellerFreightClass;
        return this;
    }

    @ApiModelProperty(value="")
    public SellerFreightClass getSellerFreightClass() {
        return this.sellerFreightClass;
    }

    public void setSellerFreightClass(SellerFreightClass sellerFreightClass) {
        this.sellerFreightClass = sellerFreightClass;
    }

    public PartneredLtlDataInput freightReadyDate(String freightReadyDate) {
        this.freightReadyDate = freightReadyDate;
        return this;
    }

    @ApiModelProperty(value="The date that the shipment will be ready to be picked up by the carrier.")
    public String getFreightReadyDate() {
        return this.freightReadyDate;
    }

    public void setFreightReadyDate(String freightReadyDate) {
        this.freightReadyDate = freightReadyDate;
    }

    public PartneredLtlDataInput palletList(PalletList palletList) {
        this.palletList = palletList;
        return this;
    }

    @ApiModelProperty(value="")
    public PalletList getPalletList() {
        return this.palletList;
    }

    public void setPalletList(PalletList palletList) {
        this.palletList = palletList;
    }

    public PartneredLtlDataInput totalWeight(Weight totalWeight) {
        this.totalWeight = totalWeight;
        return this;
    }

    @ApiModelProperty(value="The total weight of the shipment.")
    public Weight getTotalWeight() {
        return this.totalWeight;
    }

    public void setTotalWeight(Weight totalWeight) {
        this.totalWeight = totalWeight;
    }

    public PartneredLtlDataInput sellerDeclaredValue(Amount sellerDeclaredValue) {
        this.sellerDeclaredValue = sellerDeclaredValue;
        return this;
    }

    @ApiModelProperty(value="The declaration of the total value of the inventory in the shipment.")
    public Amount getSellerDeclaredValue() {
        return this.sellerDeclaredValue;
    }

    public void setSellerDeclaredValue(Amount sellerDeclaredValue) {
        this.sellerDeclaredValue = sellerDeclaredValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartneredLtlDataInput partneredLtlDataInput = (PartneredLtlDataInput)o;
        return Objects.equals(this.contact, partneredLtlDataInput.contact) && Objects.equals(this.boxCount, partneredLtlDataInput.boxCount) && Objects.equals((Object)this.sellerFreightClass, (Object)partneredLtlDataInput.sellerFreightClass) && Objects.equals(this.freightReadyDate, partneredLtlDataInput.freightReadyDate) && Objects.equals(this.palletList, partneredLtlDataInput.palletList) && Objects.equals(this.totalWeight, partneredLtlDataInput.totalWeight) && Objects.equals(this.sellerDeclaredValue, partneredLtlDataInput.sellerDeclaredValue);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.contact, this.boxCount, this.sellerFreightClass, this.freightReadyDate, this.palletList, this.totalWeight, this.sellerDeclaredValue});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PartneredLtlDataInput {\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    boxCount: ").append(this.toIndentedString(this.boxCount)).append("\n");
        sb.append("    sellerFreightClass: ").append(this.toIndentedString((Object)this.sellerFreightClass)).append("\n");
        sb.append("    freightReadyDate: ").append(this.toIndentedString(this.freightReadyDate)).append("\n");
        sb.append("    palletList: ").append(this.toIndentedString(this.palletList)).append("\n");
        sb.append("    totalWeight: ").append(this.toIndentedString(this.totalWeight)).append("\n");
        sb.append("    sellerDeclaredValue: ").append(this.toIndentedString(this.sellerDeclaredValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

