/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fulfillmentinbound;

import com.amazon.spapi.model.fulfillmentinbound.Amount;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The estimated shipping cost for a shipment using an Amazon-partnered carrier.")
public class PartneredEstimate {
    @SerializedName(value="Amount")
    private Amount amount = null;
    @SerializedName(value="ConfirmDeadline")
    private String confirmDeadline = null;
    @SerializedName(value="VoidDeadline")
    private String voidDeadline = null;

    public PartneredEstimate amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount that the Amazon-partnered carrier will charge to ship the inbound shipment.")
    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public PartneredEstimate confirmDeadline(String confirmDeadline) {
        this.confirmDeadline = confirmDeadline;
        return this;
    }

    @ApiModelProperty(value="The date in ISO 8601 date time format by which this estimate must be confirmed. After this date the estimate is no longer valid and cannot be confirmed.  Returned only if the TransportStatus value of the inbound shipment is ESTIMATED.")
    public String getConfirmDeadline() {
        return this.confirmDeadline;
    }

    public void setConfirmDeadline(String confirmDeadline) {
        this.confirmDeadline = confirmDeadline;
    }

    public PartneredEstimate voidDeadline(String voidDeadline) {
        this.voidDeadline = voidDeadline;
        return this;
    }

    @ApiModelProperty(value="The date in ISO 8601 date time format after which a confirmed transportation request can no longer be voided. This date is 24 hours after a Small Parcel shipment transportation request is confirmed or one hour after a Less Than Truckload/Full Truckload (LTL/FTL) shipment transportation request is confirmed. After the void deadline passes the seller's account will be charged for the shipping cost.  Returned only if the TransportStatus value of the inbound shipment is CONFIRMED.")
    public String getVoidDeadline() {
        return this.voidDeadline;
    }

    public void setVoidDeadline(String voidDeadline) {
        this.voidDeadline = voidDeadline;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartneredEstimate partneredEstimate = (PartneredEstimate)o;
        return Objects.equals(this.amount, partneredEstimate.amount) && Objects.equals(this.confirmDeadline, partneredEstimate.confirmDeadline) && Objects.equals(this.voidDeadline, partneredEstimate.voidDeadline);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.confirmDeadline, this.voidDeadline);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PartneredEstimate {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    confirmDeadline: ").append(this.toIndentedString(this.confirmDeadline)).append("\n");
        sb.append("    voidDeadline: ").append(this.toIndentedString(this.voidDeadline)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

