/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fulfillmentinbound;

import com.amazon.spapi.model.fulfillmentinbound.Dimensions;
import com.amazon.spapi.model.fulfillmentinbound.Weight;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Pallet information.")
public class Pallet {
    @SerializedName(value="Dimensions")
    private Dimensions dimensions = null;
    @SerializedName(value="Weight")
    private Weight weight = null;
    @SerializedName(value="IsStacked")
    private Boolean isStacked = null;

    public Pallet dimensions(Dimensions dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    @ApiModelProperty(required=true, value="The dimensions of the pallet. Length and width must be 40 inches by 48 inches. Height must be less than or equal to 60 inches.")
    public Dimensions getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Dimensions dimensions) {
        this.dimensions = dimensions;
    }

    public Pallet weight(Weight weight) {
        this.weight = weight;
        return this;
    }

    @ApiModelProperty(value="The weight of the pallet.")
    public Weight getWeight() {
        return this.weight;
    }

    public void setWeight(Weight weight) {
        this.weight = weight;
    }

    public Pallet isStacked(Boolean isStacked) {
        this.isStacked = isStacked;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether pallets will be stacked when carrier arrives for pick-up.")
    public Boolean isIsStacked() {
        return this.isStacked;
    }

    public void setIsStacked(Boolean isStacked) {
        this.isStacked = isStacked;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pallet pallet = (Pallet)o;
        return Objects.equals(this.dimensions, pallet.dimensions) && Objects.equals(this.weight, pallet.weight) && Objects.equals(this.isStacked, pallet.isStacked);
    }

    public int hashCode() {
        return Objects.hash(this.dimensions, this.weight, this.isStacked);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Pallet {\n");
        sb.append("    dimensions: ").append(this.toIndentedString(this.dimensions)).append("\n");
        sb.append("    weight: ").append(this.toIndentedString(this.weight)).append("\n");
        sb.append("    isStacked: ").append(this.toIndentedString(this.isStacked)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

