/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fulfillmentinbound;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Information that you provide to Amazon about a Less Than Truckload/Full Truckload (LTL/FTL) shipment by a carrier that has not partnered with Amazon.")
public class NonPartneredLtlDataInput {
    @SerializedName(value="CarrierName")
    private String carrierName = null;
    @SerializedName(value="ProNumber")
    private String proNumber = null;

    public NonPartneredLtlDataInput carrierName(String carrierName) {
        this.carrierName = carrierName;
        return this;
    }

    @ApiModelProperty(required=true, value="The carrier that you are using for the inbound shipment.")
    public String getCarrierName() {
        return this.carrierName;
    }

    public void setCarrierName(String carrierName) {
        this.carrierName = carrierName;
    }

    public NonPartneredLtlDataInput proNumber(String proNumber) {
        this.proNumber = proNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getProNumber() {
        return this.proNumber;
    }

    public void setProNumber(String proNumber) {
        this.proNumber = proNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NonPartneredLtlDataInput nonPartneredLtlDataInput = (NonPartneredLtlDataInput)o;
        return Objects.equals(this.carrierName, nonPartneredLtlDataInput.carrierName) && Objects.equals(this.proNumber, nonPartneredLtlDataInput.proNumber);
    }

    public int hashCode() {
        return Objects.hash(this.carrierName, this.proNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NonPartneredLtlDataInput {\n");
        sb.append("    carrierName: ").append(this.toIndentedString(this.carrierName)).append("\n");
        sb.append("    proNumber: ").append(this.toIndentedString(this.proNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

