/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fulfillmentinbound;

import com.amazon.spapi.model.fulfillmentinbound.PrepDetailsList;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Item information used to create an inbound shipment. Returned by the createInboundShipmentPlan operation.")
public class InboundShipmentPlanItem {
    @SerializedName(value="SellerSKU")
    private String sellerSKU = null;
    @SerializedName(value="FulfillmentNetworkSKU")
    private String fulfillmentNetworkSKU = null;
    @SerializedName(value="Quantity")
    private Integer quantity = null;
    @SerializedName(value="PrepDetailsList")
    private PrepDetailsList prepDetailsList = null;

    public InboundShipmentPlanItem sellerSKU(String sellerSKU) {
        this.sellerSKU = sellerSKU;
        return this;
    }

    @ApiModelProperty(required=true, value="The seller SKU of the item.")
    public String getSellerSKU() {
        return this.sellerSKU;
    }

    public void setSellerSKU(String sellerSKU) {
        this.sellerSKU = sellerSKU;
    }

    public InboundShipmentPlanItem fulfillmentNetworkSKU(String fulfillmentNetworkSKU) {
        this.fulfillmentNetworkSKU = fulfillmentNetworkSKU;
        return this;
    }

    @ApiModelProperty(required=true, value="Amazon's fulfillment network SKU of the item.")
    public String getFulfillmentNetworkSKU() {
        return this.fulfillmentNetworkSKU;
    }

    public void setFulfillmentNetworkSKU(String fulfillmentNetworkSKU) {
        this.fulfillmentNetworkSKU = fulfillmentNetworkSKU;
    }

    public InboundShipmentPlanItem quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(required=true, value="The item quantity that you are shipping.")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public InboundShipmentPlanItem prepDetailsList(PrepDetailsList prepDetailsList) {
        this.prepDetailsList = prepDetailsList;
        return this;
    }

    @ApiModelProperty(value="")
    public PrepDetailsList getPrepDetailsList() {
        return this.prepDetailsList;
    }

    public void setPrepDetailsList(PrepDetailsList prepDetailsList) {
        this.prepDetailsList = prepDetailsList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InboundShipmentPlanItem inboundShipmentPlanItem = (InboundShipmentPlanItem)o;
        return Objects.equals(this.sellerSKU, inboundShipmentPlanItem.sellerSKU) && Objects.equals(this.fulfillmentNetworkSKU, inboundShipmentPlanItem.fulfillmentNetworkSKU) && Objects.equals(this.quantity, inboundShipmentPlanItem.quantity) && Objects.equals(this.prepDetailsList, inboundShipmentPlanItem.prepDetailsList);
    }

    public int hashCode() {
        return Objects.hash(this.sellerSKU, this.fulfillmentNetworkSKU, this.quantity, this.prepDetailsList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InboundShipmentPlanItem {\n");
        sb.append("    sellerSKU: ").append(this.toIndentedString(this.sellerSKU)).append("\n");
        sb.append("    fulfillmentNetworkSKU: ").append(this.toIndentedString(this.fulfillmentNetworkSKU)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    prepDetailsList: ").append(this.toIndentedString(this.prepDetailsList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

