/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fulfillmentinbound;

import com.amazon.spapi.model.fulfillmentinbound.PrepDetailsList;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Item information for an inbound shipment. Submitted with a call to the createInboundShipment or updateInboundShipment operation.")
public class InboundShipmentItem {
    @SerializedName(value="ShipmentId")
    private String shipmentId = null;
    @SerializedName(value="SellerSKU")
    private String sellerSKU = null;
    @SerializedName(value="FulfillmentNetworkSKU")
    private String fulfillmentNetworkSKU = null;
    @SerializedName(value="QuantityShipped")
    private Integer quantityShipped = null;
    @SerializedName(value="QuantityReceived")
    private Integer quantityReceived = null;
    @SerializedName(value="QuantityInCase")
    private Integer quantityInCase = null;
    @SerializedName(value="ReleaseDate")
    private String releaseDate = null;
    @SerializedName(value="PrepDetailsList")
    private PrepDetailsList prepDetailsList = null;

    public InboundShipmentItem shipmentId(String shipmentId) {
        this.shipmentId = shipmentId;
        return this;
    }

    @ApiModelProperty(value="A shipment identifier originally returned by the createInboundShipmentPlan operation.")
    public String getShipmentId() {
        return this.shipmentId;
    }

    public void setShipmentId(String shipmentId) {
        this.shipmentId = shipmentId;
    }

    public InboundShipmentItem sellerSKU(String sellerSKU) {
        this.sellerSKU = sellerSKU;
        return this;
    }

    @ApiModelProperty(required=true, value="The seller SKU of the item.")
    public String getSellerSKU() {
        return this.sellerSKU;
    }

    public void setSellerSKU(String sellerSKU) {
        this.sellerSKU = sellerSKU;
    }

    public InboundShipmentItem fulfillmentNetworkSKU(String fulfillmentNetworkSKU) {
        this.fulfillmentNetworkSKU = fulfillmentNetworkSKU;
        return this;
    }

    @ApiModelProperty(value="Amazon's fulfillment network SKU of the item.")
    public String getFulfillmentNetworkSKU() {
        return this.fulfillmentNetworkSKU;
    }

    public void setFulfillmentNetworkSKU(String fulfillmentNetworkSKU) {
        this.fulfillmentNetworkSKU = fulfillmentNetworkSKU;
    }

    public InboundShipmentItem quantityShipped(Integer quantityShipped) {
        this.quantityShipped = quantityShipped;
        return this;
    }

    @ApiModelProperty(required=true, value="The item quantity that you are shipping.")
    public Integer getQuantityShipped() {
        return this.quantityShipped;
    }

    public void setQuantityShipped(Integer quantityShipped) {
        this.quantityShipped = quantityShipped;
    }

    public InboundShipmentItem quantityReceived(Integer quantityReceived) {
        this.quantityReceived = quantityReceived;
        return this;
    }

    @ApiModelProperty(value="The item quantity that has been received at an Amazon fulfillment center.")
    public Integer getQuantityReceived() {
        return this.quantityReceived;
    }

    public void setQuantityReceived(Integer quantityReceived) {
        this.quantityReceived = quantityReceived;
    }

    public InboundShipmentItem quantityInCase(Integer quantityInCase) {
        this.quantityInCase = quantityInCase;
        return this;
    }

    @ApiModelProperty(value="The item quantity in each case, for case-packed items. Note that QuantityInCase multiplied by the number of boxes in the inbound shipment equals QuantityShipped. Also note that all of the boxes of an inbound shipment must either be case packed or individually packed. For that reason, when you submit the createInboundShipment or the updateInboundShipment operation, the value of QuantityInCase must be provided for every item in the shipment or for none of the items in the shipment.")
    public Integer getQuantityInCase() {
        return this.quantityInCase;
    }

    public void setQuantityInCase(Integer quantityInCase) {
        this.quantityInCase = quantityInCase;
    }

    public InboundShipmentItem releaseDate(String releaseDate) {
        this.releaseDate = releaseDate;
        return this;
    }

    @ApiModelProperty(value="The date that a pre-order item will be available for sale.")
    public String getReleaseDate() {
        return this.releaseDate;
    }

    public void setReleaseDate(String releaseDate) {
        this.releaseDate = releaseDate;
    }

    public InboundShipmentItem prepDetailsList(PrepDetailsList prepDetailsList) {
        this.prepDetailsList = prepDetailsList;
        return this;
    }

    @ApiModelProperty(value="")
    public PrepDetailsList getPrepDetailsList() {
        return this.prepDetailsList;
    }

    public void setPrepDetailsList(PrepDetailsList prepDetailsList) {
        this.prepDetailsList = prepDetailsList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InboundShipmentItem inboundShipmentItem = (InboundShipmentItem)o;
        return Objects.equals(this.shipmentId, inboundShipmentItem.shipmentId) && Objects.equals(this.sellerSKU, inboundShipmentItem.sellerSKU) && Objects.equals(this.fulfillmentNetworkSKU, inboundShipmentItem.fulfillmentNetworkSKU) && Objects.equals(this.quantityShipped, inboundShipmentItem.quantityShipped) && Objects.equals(this.quantityReceived, inboundShipmentItem.quantityReceived) && Objects.equals(this.quantityInCase, inboundShipmentItem.quantityInCase) && Objects.equals(this.releaseDate, inboundShipmentItem.releaseDate) && Objects.equals(this.prepDetailsList, inboundShipmentItem.prepDetailsList);
    }

    public int hashCode() {
        return Objects.hash(this.shipmentId, this.sellerSKU, this.fulfillmentNetworkSKU, this.quantityShipped, this.quantityReceived, this.quantityInCase, this.releaseDate, this.prepDetailsList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InboundShipmentItem {\n");
        sb.append("    shipmentId: ").append(this.toIndentedString(this.shipmentId)).append("\n");
        sb.append("    sellerSKU: ").append(this.toIndentedString(this.sellerSKU)).append("\n");
        sb.append("    fulfillmentNetworkSKU: ").append(this.toIndentedString(this.fulfillmentNetworkSKU)).append("\n");
        sb.append("    quantityShipped: ").append(this.toIndentedString(this.quantityShipped)).append("\n");
        sb.append("    quantityReceived: ").append(this.toIndentedString(this.quantityReceived)).append("\n");
        sb.append("    quantityInCase: ").append(this.toIndentedString(this.quantityInCase)).append("\n");
        sb.append("    releaseDate: ").append(this.toIndentedString(this.releaseDate)).append("\n");
        sb.append("    prepDetailsList: ").append(this.toIndentedString(this.prepDetailsList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

