/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fulfillmentinbound;

import com.amazon.spapi.model.fulfillmentinbound.Address;
import com.amazon.spapi.model.fulfillmentinbound.BoxContentsFeeDetails;
import com.amazon.spapi.model.fulfillmentinbound.BoxContentsSource;
import com.amazon.spapi.model.fulfillmentinbound.LabelPrepType;
import com.amazon.spapi.model.fulfillmentinbound.ShipmentStatus;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Information about the seller's inbound shipments. Returned by the listInboundShipments operation.")
public class InboundShipmentInfo {
    @SerializedName(value="ShipmentId")
    private String shipmentId = null;
    @SerializedName(value="ShipmentName")
    private String shipmentName = null;
    @SerializedName(value="ShipFromAddress")
    private Address shipFromAddress = null;
    @SerializedName(value="DestinationFulfillmentCenterId")
    private String destinationFulfillmentCenterId = null;
    @SerializedName(value="ShipmentStatus")
    private ShipmentStatus shipmentStatus = null;
    @SerializedName(value="LabelPrepType")
    private LabelPrepType labelPrepType = null;
    @SerializedName(value="AreCasesRequired")
    private Boolean areCasesRequired = null;
    @SerializedName(value="ConfirmedNeedByDate")
    private String confirmedNeedByDate = null;
    @SerializedName(value="BoxContentsSource")
    private BoxContentsSource boxContentsSource = null;
    @SerializedName(value="EstimatedBoxContentsFee")
    private BoxContentsFeeDetails estimatedBoxContentsFee = null;

    public InboundShipmentInfo shipmentId(String shipmentId) {
        this.shipmentId = shipmentId;
        return this;
    }

    @ApiModelProperty(value="The shipment identifier submitted in the request.")
    public String getShipmentId() {
        return this.shipmentId;
    }

    public void setShipmentId(String shipmentId) {
        this.shipmentId = shipmentId;
    }

    public InboundShipmentInfo shipmentName(String shipmentName) {
        this.shipmentName = shipmentName;
        return this;
    }

    @ApiModelProperty(value="The name for the inbound shipment.")
    public String getShipmentName() {
        return this.shipmentName;
    }

    public void setShipmentName(String shipmentName) {
        this.shipmentName = shipmentName;
    }

    public InboundShipmentInfo shipFromAddress(Address shipFromAddress) {
        this.shipFromAddress = shipFromAddress;
        return this;
    }

    @ApiModelProperty(required=true, value="The return address.")
    public Address getShipFromAddress() {
        return this.shipFromAddress;
    }

    public void setShipFromAddress(Address shipFromAddress) {
        this.shipFromAddress = shipFromAddress;
    }

    public InboundShipmentInfo destinationFulfillmentCenterId(String destinationFulfillmentCenterId) {
        this.destinationFulfillmentCenterId = destinationFulfillmentCenterId;
        return this;
    }

    @ApiModelProperty(value="An Amazon fulfillment center identifier created by Amazon.")
    public String getDestinationFulfillmentCenterId() {
        return this.destinationFulfillmentCenterId;
    }

    public void setDestinationFulfillmentCenterId(String destinationFulfillmentCenterId) {
        this.destinationFulfillmentCenterId = destinationFulfillmentCenterId;
    }

    public InboundShipmentInfo shipmentStatus(ShipmentStatus shipmentStatus) {
        this.shipmentStatus = shipmentStatus;
        return this;
    }

    @ApiModelProperty(value="")
    public ShipmentStatus getShipmentStatus() {
        return this.shipmentStatus;
    }

    public void setShipmentStatus(ShipmentStatus shipmentStatus) {
        this.shipmentStatus = shipmentStatus;
    }

    public InboundShipmentInfo labelPrepType(LabelPrepType labelPrepType) {
        this.labelPrepType = labelPrepType;
        return this;
    }

    @ApiModelProperty(value="")
    public LabelPrepType getLabelPrepType() {
        return this.labelPrepType;
    }

    public void setLabelPrepType(LabelPrepType labelPrepType) {
        this.labelPrepType = labelPrepType;
    }

    public InboundShipmentInfo areCasesRequired(Boolean areCasesRequired) {
        this.areCasesRequired = areCasesRequired;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether or not an inbound shipment contains case-packed boxes. When AreCasesRequired = true for an inbound shipment, all items in the inbound shipment must be case packed.")
    public Boolean isAreCasesRequired() {
        return this.areCasesRequired;
    }

    public void setAreCasesRequired(Boolean areCasesRequired) {
        this.areCasesRequired = areCasesRequired;
    }

    public InboundShipmentInfo confirmedNeedByDate(String confirmedNeedByDate) {
        this.confirmedNeedByDate = confirmedNeedByDate;
        return this;
    }

    @ApiModelProperty(value="Date by which the shipment must arrive at the Amazon fulfillment center to avoid delivery promise breaks for pre-ordered items.")
    public String getConfirmedNeedByDate() {
        return this.confirmedNeedByDate;
    }

    public void setConfirmedNeedByDate(String confirmedNeedByDate) {
        this.confirmedNeedByDate = confirmedNeedByDate;
    }

    public InboundShipmentInfo boxContentsSource(BoxContentsSource boxContentsSource) {
        this.boxContentsSource = boxContentsSource;
        return this;
    }

    @ApiModelProperty(value="")
    public BoxContentsSource getBoxContentsSource() {
        return this.boxContentsSource;
    }

    public void setBoxContentsSource(BoxContentsSource boxContentsSource) {
        this.boxContentsSource = boxContentsSource;
    }

    public InboundShipmentInfo estimatedBoxContentsFee(BoxContentsFeeDetails estimatedBoxContentsFee) {
        this.estimatedBoxContentsFee = estimatedBoxContentsFee;
        return this;
    }

    @ApiModelProperty(value="An estimate of the manual processing fee charged by Amazon for boxes without box content information. This is only returned when BoxContentsSource is NONE.")
    public BoxContentsFeeDetails getEstimatedBoxContentsFee() {
        return this.estimatedBoxContentsFee;
    }

    public void setEstimatedBoxContentsFee(BoxContentsFeeDetails estimatedBoxContentsFee) {
        this.estimatedBoxContentsFee = estimatedBoxContentsFee;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InboundShipmentInfo inboundShipmentInfo = (InboundShipmentInfo)o;
        return Objects.equals(this.shipmentId, inboundShipmentInfo.shipmentId) && Objects.equals(this.shipmentName, inboundShipmentInfo.shipmentName) && Objects.equals(this.shipFromAddress, inboundShipmentInfo.shipFromAddress) && Objects.equals(this.destinationFulfillmentCenterId, inboundShipmentInfo.destinationFulfillmentCenterId) && Objects.equals((Object)this.shipmentStatus, (Object)inboundShipmentInfo.shipmentStatus) && Objects.equals((Object)this.labelPrepType, (Object)inboundShipmentInfo.labelPrepType) && Objects.equals(this.areCasesRequired, inboundShipmentInfo.areCasesRequired) && Objects.equals(this.confirmedNeedByDate, inboundShipmentInfo.confirmedNeedByDate) && Objects.equals((Object)this.boxContentsSource, (Object)inboundShipmentInfo.boxContentsSource) && Objects.equals(this.estimatedBoxContentsFee, inboundShipmentInfo.estimatedBoxContentsFee);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.shipmentId, this.shipmentName, this.shipFromAddress, this.destinationFulfillmentCenterId, this.shipmentStatus, this.labelPrepType, this.areCasesRequired, this.confirmedNeedByDate, this.boxContentsSource, this.estimatedBoxContentsFee});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InboundShipmentInfo {\n");
        sb.append("    shipmentId: ").append(this.toIndentedString(this.shipmentId)).append("\n");
        sb.append("    shipmentName: ").append(this.toIndentedString(this.shipmentName)).append("\n");
        sb.append("    shipFromAddress: ").append(this.toIndentedString(this.shipFromAddress)).append("\n");
        sb.append("    destinationFulfillmentCenterId: ").append(this.toIndentedString(this.destinationFulfillmentCenterId)).append("\n");
        sb.append("    shipmentStatus: ").append(this.toIndentedString((Object)this.shipmentStatus)).append("\n");
        sb.append("    labelPrepType: ").append(this.toIndentedString((Object)this.labelPrepType)).append("\n");
        sb.append("    areCasesRequired: ").append(this.toIndentedString(this.areCasesRequired)).append("\n");
        sb.append("    confirmedNeedByDate: ").append(this.toIndentedString(this.confirmedNeedByDate)).append("\n");
        sb.append("    boxContentsSource: ").append(this.toIndentedString((Object)this.boxContentsSource)).append("\n");
        sb.append("    estimatedBoxContentsFee: ").append(this.toIndentedString(this.estimatedBoxContentsFee)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

