/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fulfillmentinbound;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class GetPreorderInfoResult {
    @SerializedName(value="ShipmentContainsPreorderableItems")
    private Boolean shipmentContainsPreorderableItems = null;
    @SerializedName(value="ShipmentConfirmedForPreorder")
    private Boolean shipmentConfirmedForPreorder = null;
    @SerializedName(value="NeedByDate")
    private String needByDate = null;
    @SerializedName(value="ConfirmedFulfillableDate")
    private String confirmedFulfillableDate = null;

    public GetPreorderInfoResult shipmentContainsPreorderableItems(Boolean shipmentContainsPreorderableItems) {
        this.shipmentContainsPreorderableItems = shipmentContainsPreorderableItems;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the shipment contains items that have been enabled for pre-order. For more information about enabling items for pre-order, see the Seller Central Help.")
    public Boolean isShipmentContainsPreorderableItems() {
        return this.shipmentContainsPreorderableItems;
    }

    public void setShipmentContainsPreorderableItems(Boolean shipmentContainsPreorderableItems) {
        this.shipmentContainsPreorderableItems = shipmentContainsPreorderableItems;
    }

    public GetPreorderInfoResult shipmentConfirmedForPreorder(Boolean shipmentConfirmedForPreorder) {
        this.shipmentConfirmedForPreorder = shipmentConfirmedForPreorder;
        return this;
    }

    @ApiModelProperty(value="Indicates whether this shipment has been confirmed for pre-order.")
    public Boolean isShipmentConfirmedForPreorder() {
        return this.shipmentConfirmedForPreorder;
    }

    public void setShipmentConfirmedForPreorder(Boolean shipmentConfirmedForPreorder) {
        this.shipmentConfirmedForPreorder = shipmentConfirmedForPreorder;
    }

    public GetPreorderInfoResult needByDate(String needByDate) {
        this.needByDate = needByDate;
        return this;
    }

    @ApiModelProperty(value="Date that the shipment would need to arrive at an Amazon fulfillment center to avoid delivery promise breaks for pre-ordered items if this shipment is later confirmed for pre-order. In YYYY-MM-DD format. See also the confirmPreorder operation.")
    public String getNeedByDate() {
        return this.needByDate;
    }

    public void setNeedByDate(String needByDate) {
        this.needByDate = needByDate;
    }

    public GetPreorderInfoResult confirmedFulfillableDate(String confirmedFulfillableDate) {
        this.confirmedFulfillableDate = confirmedFulfillableDate;
        return this;
    }

    @ApiModelProperty(value="Date in YYYY-MM-DD format that determines which pre-order items in the shipment are eligible for pre-order. If this shipment is confirmed for pre-order with a subsequent call to the confirmPreorder operation, the pre-order Buy Box will appear for any pre-order items in the shipment with a release date on or after this date. Call the getShipmentItems operation to get the release dates for the pre-order items in this shipment.")
    public String getConfirmedFulfillableDate() {
        return this.confirmedFulfillableDate;
    }

    public void setConfirmedFulfillableDate(String confirmedFulfillableDate) {
        this.confirmedFulfillableDate = confirmedFulfillableDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetPreorderInfoResult getPreorderInfoResult = (GetPreorderInfoResult)o;
        return Objects.equals(this.shipmentContainsPreorderableItems, getPreorderInfoResult.shipmentContainsPreorderableItems) && Objects.equals(this.shipmentConfirmedForPreorder, getPreorderInfoResult.shipmentConfirmedForPreorder) && Objects.equals(this.needByDate, getPreorderInfoResult.needByDate) && Objects.equals(this.confirmedFulfillableDate, getPreorderInfoResult.confirmedFulfillableDate);
    }

    public int hashCode() {
        return Objects.hash(this.shipmentContainsPreorderableItems, this.shipmentConfirmedForPreorder, this.needByDate, this.confirmedFulfillableDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetPreorderInfoResult {\n");
        sb.append("    shipmentContainsPreorderableItems: ").append(this.toIndentedString(this.shipmentContainsPreorderableItems)).append("\n");
        sb.append("    shipmentConfirmedForPreorder: ").append(this.toIndentedString(this.shipmentConfirmedForPreorder)).append("\n");
        sb.append("    needByDate: ").append(this.toIndentedString(this.needByDate)).append("\n");
        sb.append("    confirmedFulfillableDate: ").append(this.toIndentedString(this.confirmedFulfillableDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

