/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fulfillmentinbound;

import com.amazon.spapi.model.fulfillmentinbound.Address;
import com.amazon.spapi.model.fulfillmentinbound.InboundShipmentPlanRequestItemList;
import com.amazon.spapi.model.fulfillmentinbound.LabelPrepPreference;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The request schema for the createInboundShipmentPlan operation.")
public class CreateInboundShipmentPlanRequest {
    @SerializedName(value="ShipFromAddress")
    private Address shipFromAddress = null;
    @SerializedName(value="LabelPrepPreference")
    private LabelPrepPreference labelPrepPreference = null;
    @SerializedName(value="ShipToCountryCode")
    private String shipToCountryCode = null;
    @SerializedName(value="ShipToCountrySubdivisionCode")
    private String shipToCountrySubdivisionCode = null;
    @SerializedName(value="InboundShipmentPlanRequestItems")
    private InboundShipmentPlanRequestItemList inboundShipmentPlanRequestItems = null;

    public CreateInboundShipmentPlanRequest shipFromAddress(Address shipFromAddress) {
        this.shipFromAddress = shipFromAddress;
        return this;
    }

    @ApiModelProperty(required=true, value="The address from which the inbound shipment will be sent.")
    public Address getShipFromAddress() {
        return this.shipFromAddress;
    }

    public void setShipFromAddress(Address shipFromAddress) {
        this.shipFromAddress = shipFromAddress;
    }

    public CreateInboundShipmentPlanRequest labelPrepPreference(LabelPrepPreference labelPrepPreference) {
        this.labelPrepPreference = labelPrepPreference;
        return this;
    }

    @ApiModelProperty(required=true, value="The seller's preference for label preparation for an inbound shipment.")
    public LabelPrepPreference getLabelPrepPreference() {
        return this.labelPrepPreference;
    }

    public void setLabelPrepPreference(LabelPrepPreference labelPrepPreference) {
        this.labelPrepPreference = labelPrepPreference;
    }

    public CreateInboundShipmentPlanRequest shipToCountryCode(String shipToCountryCode) {
        this.shipToCountryCode = shipToCountryCode;
        return this;
    }

    @ApiModelProperty(value="The two-character country code for the country where the inbound shipment is to be sent.  Note: Not required. Specifying both ShipToCountryCode and ShipToCountrySubdivisionCode returns an error.   Values:   ShipToCountryCode values for North America:  * CA \u2013 Canada  * MX - Mexico  * US - United States  ShipToCountryCode values for MCI sellers in Europe:  * DE \u2013 Germany  * ES \u2013 Spain  * FR \u2013 France  * GB \u2013 United Kingdom  * IT \u2013 Italy  Default: The country code for the seller's home marketplace.")
    public String getShipToCountryCode() {
        return this.shipToCountryCode;
    }

    public void setShipToCountryCode(String shipToCountryCode) {
        this.shipToCountryCode = shipToCountryCode;
    }

    public CreateInboundShipmentPlanRequest shipToCountrySubdivisionCode(String shipToCountrySubdivisionCode) {
        this.shipToCountrySubdivisionCode = shipToCountrySubdivisionCode;
        return this;
    }

    @ApiModelProperty(value="The two-character country code, followed by a dash and then up to three characters that represent the subdivision of the country where the inbound shipment is to be sent. For example, \"IN-MH\". In full ISO 3166-2 format.  Note: Not required. Specifying both ShipToCountryCode and ShipToCountrySubdivisionCode returns an error.")
    public String getShipToCountrySubdivisionCode() {
        return this.shipToCountrySubdivisionCode;
    }

    public void setShipToCountrySubdivisionCode(String shipToCountrySubdivisionCode) {
        this.shipToCountrySubdivisionCode = shipToCountrySubdivisionCode;
    }

    public CreateInboundShipmentPlanRequest inboundShipmentPlanRequestItems(InboundShipmentPlanRequestItemList inboundShipmentPlanRequestItems) {
        this.inboundShipmentPlanRequestItems = inboundShipmentPlanRequestItems;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public InboundShipmentPlanRequestItemList getInboundShipmentPlanRequestItems() {
        return this.inboundShipmentPlanRequestItems;
    }

    public void setInboundShipmentPlanRequestItems(InboundShipmentPlanRequestItemList inboundShipmentPlanRequestItems) {
        this.inboundShipmentPlanRequestItems = inboundShipmentPlanRequestItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateInboundShipmentPlanRequest createInboundShipmentPlanRequest = (CreateInboundShipmentPlanRequest)o;
        return Objects.equals(this.shipFromAddress, createInboundShipmentPlanRequest.shipFromAddress) && Objects.equals((Object)this.labelPrepPreference, (Object)createInboundShipmentPlanRequest.labelPrepPreference) && Objects.equals(this.shipToCountryCode, createInboundShipmentPlanRequest.shipToCountryCode) && Objects.equals(this.shipToCountrySubdivisionCode, createInboundShipmentPlanRequest.shipToCountrySubdivisionCode) && Objects.equals(this.inboundShipmentPlanRequestItems, createInboundShipmentPlanRequest.inboundShipmentPlanRequestItems);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.shipFromAddress, this.labelPrepPreference, this.shipToCountryCode, this.shipToCountrySubdivisionCode, this.inboundShipmentPlanRequestItems});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateInboundShipmentPlanRequest {\n");
        sb.append("    shipFromAddress: ").append(this.toIndentedString(this.shipFromAddress)).append("\n");
        sb.append("    labelPrepPreference: ").append(this.toIndentedString((Object)this.labelPrepPreference)).append("\n");
        sb.append("    shipToCountryCode: ").append(this.toIndentedString(this.shipToCountryCode)).append("\n");
        sb.append("    shipToCountrySubdivisionCode: ").append(this.toIndentedString(this.shipToCountrySubdivisionCode)).append("\n");
        sb.append("    inboundShipmentPlanRequestItems: ").append(this.toIndentedString(this.inboundShipmentPlanRequestItems)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

