/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fulfillmentinbound;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Contact information for the person in the seller's organization who is responsible for a Less Than Truckload/Full Truckload (LTL/FTL) shipment.")
public class Contact {
    @SerializedName(value="Name")
    private String name = null;
    @SerializedName(value="Phone")
    private String phone = null;
    @SerializedName(value="Email")
    private String email = null;
    @SerializedName(value="Fax")
    private String fax = null;

    public Contact name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the contact person.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Contact phone(String phone) {
        this.phone = phone;
        return this;
    }

    @ApiModelProperty(required=true, value="The phone number of the contact person.")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Contact email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(required=true, value="The email address of the contact person.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Contact fax(String fax) {
        this.fax = fax;
        return this;
    }

    @ApiModelProperty(value="The fax number of the contact person.")
    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Contact contact = (Contact)o;
        return Objects.equals(this.name, contact.name) && Objects.equals(this.phone, contact.phone) && Objects.equals(this.email, contact.email) && Objects.equals(this.fax, contact.fax);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.phone, this.email, this.fax);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Contact {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    fax: ").append(this.toIndentedString(this.fax)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

