/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.finances;

import com.amazon.spapi.model.finances.FeeComponentList;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="An event related to a trial shipment.")
public class TrialShipmentEvent {
    @SerializedName(value="AmazonOrderId")
    private String amazonOrderId = null;
    @SerializedName(value="FinancialEventGroupId")
    private String financialEventGroupId = null;
    @SerializedName(value="PostedDate")
    private String postedDate = null;
    @SerializedName(value="SKU")
    private String SKU = null;
    @SerializedName(value="FeeList")
    private FeeComponentList feeList = null;

    public TrialShipmentEvent amazonOrderId(String amazonOrderId) {
        this.amazonOrderId = amazonOrderId;
        return this;
    }

    @ApiModelProperty(value="An Amazon-defined identifier for an order.")
    public String getAmazonOrderId() {
        return this.amazonOrderId;
    }

    public void setAmazonOrderId(String amazonOrderId) {
        this.amazonOrderId = amazonOrderId;
    }

    public TrialShipmentEvent financialEventGroupId(String financialEventGroupId) {
        this.financialEventGroupId = financialEventGroupId;
        return this;
    }

    @ApiModelProperty(value="The identifier of the financial event group.")
    public String getFinancialEventGroupId() {
        return this.financialEventGroupId;
    }

    public void setFinancialEventGroupId(String financialEventGroupId) {
        this.financialEventGroupId = financialEventGroupId;
    }

    public TrialShipmentEvent postedDate(String postedDate) {
        this.postedDate = postedDate;
        return this;
    }

    @ApiModelProperty(value="The date and time when the financial event was posted.")
    public String getPostedDate() {
        return this.postedDate;
    }

    public void setPostedDate(String postedDate) {
        this.postedDate = postedDate;
    }

    public TrialShipmentEvent SKU(String SKU) {
        this.SKU = SKU;
        return this;
    }

    @ApiModelProperty(value="The seller SKU of the item. The seller SKU is qualified by the seller's seller ID, which is included with every call to the Selling Partner API.")
    public String getSKU() {
        return this.SKU;
    }

    public void setSKU(String SKU) {
        this.SKU = SKU;
    }

    public TrialShipmentEvent feeList(FeeComponentList feeList) {
        this.feeList = feeList;
        return this;
    }

    @ApiModelProperty(value="A list of fees charged by Amazon for trial shipments.")
    public FeeComponentList getFeeList() {
        return this.feeList;
    }

    public void setFeeList(FeeComponentList feeList) {
        this.feeList = feeList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrialShipmentEvent trialShipmentEvent = (TrialShipmentEvent)o;
        return Objects.equals(this.amazonOrderId, trialShipmentEvent.amazonOrderId) && Objects.equals(this.financialEventGroupId, trialShipmentEvent.financialEventGroupId) && Objects.equals(this.postedDate, trialShipmentEvent.postedDate) && Objects.equals(this.SKU, trialShipmentEvent.SKU) && Objects.equals(this.feeList, trialShipmentEvent.feeList);
    }

    public int hashCode() {
        return Objects.hash(this.amazonOrderId, this.financialEventGroupId, this.postedDate, this.SKU, this.feeList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TrialShipmentEvent {\n");
        sb.append("    amazonOrderId: ").append(this.toIndentedString(this.amazonOrderId)).append("\n");
        sb.append("    financialEventGroupId: ").append(this.toIndentedString(this.financialEventGroupId)).append("\n");
        sb.append("    postedDate: ").append(this.toIndentedString(this.postedDate)).append("\n");
        sb.append("    SKU: ").append(this.toIndentedString(this.SKU)).append("\n");
        sb.append("    feeList: ").append(this.toIndentedString(this.feeList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

