/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.finances;

import com.amazon.spapi.model.finances.Currency;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A tax deduction at source (TDS) claim reimbursement event on the seller's account.")
public class TDSReimbursementEvent {
    @SerializedName(value="PostedDate")
    private String postedDate = null;
    @SerializedName(value="TdsOrderId")
    private String tdsOrderId = null;
    @SerializedName(value="ReimbursedAmount")
    private Currency reimbursedAmount = null;

    public TDSReimbursementEvent postedDate(String postedDate) {
        this.postedDate = postedDate;
        return this;
    }

    @ApiModelProperty(value="The date and time when the financial event was posted.")
    public String getPostedDate() {
        return this.postedDate;
    }

    public void setPostedDate(String postedDate) {
        this.postedDate = postedDate;
    }

    public TDSReimbursementEvent tdsOrderId(String tdsOrderId) {
        this.tdsOrderId = tdsOrderId;
        return this;
    }

    @ApiModelProperty(value="A tax deduction at source (TDS) claim identifier.")
    public String getTdsOrderId() {
        return this.tdsOrderId;
    }

    public void setTdsOrderId(String tdsOrderId) {
        this.tdsOrderId = tdsOrderId;
    }

    public TDSReimbursementEvent reimbursedAmount(Currency reimbursedAmount) {
        this.reimbursedAmount = reimbursedAmount;
        return this;
    }

    @ApiModelProperty(value="The amount of the reimbursement.")
    public Currency getReimbursedAmount() {
        return this.reimbursedAmount;
    }

    public void setReimbursedAmount(Currency reimbursedAmount) {
        this.reimbursedAmount = reimbursedAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TDSReimbursementEvent tdSReimbursementEvent = (TDSReimbursementEvent)o;
        return Objects.equals(this.postedDate, tdSReimbursementEvent.postedDate) && Objects.equals(this.tdsOrderId, tdSReimbursementEvent.tdsOrderId) && Objects.equals(this.reimbursedAmount, tdSReimbursementEvent.reimbursedAmount);
    }

    public int hashCode() {
        return Objects.hash(this.postedDate, this.tdsOrderId, this.reimbursedAmount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TDSReimbursementEvent {\n");
        sb.append("    postedDate: ").append(this.toIndentedString(this.postedDate)).append("\n");
        sb.append("    tdsOrderId: ").append(this.toIndentedString(this.tdsOrderId)).append("\n");
        sb.append("    reimbursedAmount: ").append(this.toIndentedString(this.reimbursedAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

