/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.finances;

import com.amazon.spapi.model.finances.ChargeComponentList;
import com.amazon.spapi.model.finances.Currency;
import com.amazon.spapi.model.finances.FeeComponentList;
import com.amazon.spapi.model.finances.PromotionList;
import com.amazon.spapi.model.finances.TaxWithheldComponentList;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="An item of a shipment, refund, guarantee claim, or chargeback.")
public class ShipmentItem {
    @SerializedName(value="SellerSKU")
    private String sellerSKU = null;
    @SerializedName(value="OrderItemId")
    private String orderItemId = null;
    @SerializedName(value="OrderAdjustmentItemId")
    private String orderAdjustmentItemId = null;
    @SerializedName(value="QuantityShipped")
    private Integer quantityShipped = null;
    @SerializedName(value="ItemChargeList")
    private ChargeComponentList itemChargeList = null;
    @SerializedName(value="ItemChargeAdjustmentList")
    private ChargeComponentList itemChargeAdjustmentList = null;
    @SerializedName(value="ItemFeeList")
    private FeeComponentList itemFeeList = null;
    @SerializedName(value="ItemFeeAdjustmentList")
    private FeeComponentList itemFeeAdjustmentList = null;
    @SerializedName(value="ItemTaxWithheldList")
    private TaxWithheldComponentList itemTaxWithheldList = null;
    @SerializedName(value="PromotionList")
    private PromotionList promotionList = null;
    @SerializedName(value="PromotionAdjustmentList")
    private PromotionList promotionAdjustmentList = null;
    @SerializedName(value="CostOfPointsGranted")
    private Currency costOfPointsGranted = null;
    @SerializedName(value="CostOfPointsReturned")
    private Currency costOfPointsReturned = null;

    public ShipmentItem sellerSKU(String sellerSKU) {
        this.sellerSKU = sellerSKU;
        return this;
    }

    @ApiModelProperty(value="The seller SKU of the item. The seller SKU is qualified by the seller's seller ID, which is included with every call to the Selling Partner API.")
    public String getSellerSKU() {
        return this.sellerSKU;
    }

    public void setSellerSKU(String sellerSKU) {
        this.sellerSKU = sellerSKU;
    }

    public ShipmentItem orderItemId(String orderItemId) {
        this.orderItemId = orderItemId;
        return this;
    }

    @ApiModelProperty(value="An Amazon-defined order item identifier.")
    public String getOrderItemId() {
        return this.orderItemId;
    }

    public void setOrderItemId(String orderItemId) {
        this.orderItemId = orderItemId;
    }

    public ShipmentItem orderAdjustmentItemId(String orderAdjustmentItemId) {
        this.orderAdjustmentItemId = orderAdjustmentItemId;
        return this;
    }

    @ApiModelProperty(value="An Amazon-defined order adjustment identifier defined for refunds, guarantee claims, and chargeback events.")
    public String getOrderAdjustmentItemId() {
        return this.orderAdjustmentItemId;
    }

    public void setOrderAdjustmentItemId(String orderAdjustmentItemId) {
        this.orderAdjustmentItemId = orderAdjustmentItemId;
    }

    public ShipmentItem quantityShipped(Integer quantityShipped) {
        this.quantityShipped = quantityShipped;
        return this;
    }

    @ApiModelProperty(value="The number of items shipped.")
    public Integer getQuantityShipped() {
        return this.quantityShipped;
    }

    public void setQuantityShipped(Integer quantityShipped) {
        this.quantityShipped = quantityShipped;
    }

    public ShipmentItem itemChargeList(ChargeComponentList itemChargeList) {
        this.itemChargeList = itemChargeList;
        return this;
    }

    @ApiModelProperty(value="A list of charges associated with the shipment item.")
    public ChargeComponentList getItemChargeList() {
        return this.itemChargeList;
    }

    public void setItemChargeList(ChargeComponentList itemChargeList) {
        this.itemChargeList = itemChargeList;
    }

    public ShipmentItem itemChargeAdjustmentList(ChargeComponentList itemChargeAdjustmentList) {
        this.itemChargeAdjustmentList = itemChargeAdjustmentList;
        return this;
    }

    @ApiModelProperty(value="A list of charge adjustments associated with the shipment item. This value is only returned for refunds, guarantee claims, and chargeback events.")
    public ChargeComponentList getItemChargeAdjustmentList() {
        return this.itemChargeAdjustmentList;
    }

    public void setItemChargeAdjustmentList(ChargeComponentList itemChargeAdjustmentList) {
        this.itemChargeAdjustmentList = itemChargeAdjustmentList;
    }

    public ShipmentItem itemFeeList(FeeComponentList itemFeeList) {
        this.itemFeeList = itemFeeList;
        return this;
    }

    @ApiModelProperty(value="A list of fees associated with the shipment item.")
    public FeeComponentList getItemFeeList() {
        return this.itemFeeList;
    }

    public void setItemFeeList(FeeComponentList itemFeeList) {
        this.itemFeeList = itemFeeList;
    }

    public ShipmentItem itemFeeAdjustmentList(FeeComponentList itemFeeAdjustmentList) {
        this.itemFeeAdjustmentList = itemFeeAdjustmentList;
        return this;
    }

    @ApiModelProperty(value="A list of fee adjustments associated with the shipment item. This value is only returned for refunds, guarantee claims, and chargeback events.")
    public FeeComponentList getItemFeeAdjustmentList() {
        return this.itemFeeAdjustmentList;
    }

    public void setItemFeeAdjustmentList(FeeComponentList itemFeeAdjustmentList) {
        this.itemFeeAdjustmentList = itemFeeAdjustmentList;
    }

    public ShipmentItem itemTaxWithheldList(TaxWithheldComponentList itemTaxWithheldList) {
        this.itemTaxWithheldList = itemTaxWithheldList;
        return this;
    }

    @ApiModelProperty(value="A list of taxes withheld information for a shipment item.")
    public TaxWithheldComponentList getItemTaxWithheldList() {
        return this.itemTaxWithheldList;
    }

    public void setItemTaxWithheldList(TaxWithheldComponentList itemTaxWithheldList) {
        this.itemTaxWithheldList = itemTaxWithheldList;
    }

    public ShipmentItem promotionList(PromotionList promotionList) {
        this.promotionList = promotionList;
        return this;
    }

    @ApiModelProperty(value="")
    public PromotionList getPromotionList() {
        return this.promotionList;
    }

    public void setPromotionList(PromotionList promotionList) {
        this.promotionList = promotionList;
    }

    public ShipmentItem promotionAdjustmentList(PromotionList promotionAdjustmentList) {
        this.promotionAdjustmentList = promotionAdjustmentList;
        return this;
    }

    @ApiModelProperty(value="A list of promotion adjustments associated with the shipment item. This value is only returned for refunds, guarantee claims, and chargeback events.")
    public PromotionList getPromotionAdjustmentList() {
        return this.promotionAdjustmentList;
    }

    public void setPromotionAdjustmentList(PromotionList promotionAdjustmentList) {
        this.promotionAdjustmentList = promotionAdjustmentList;
    }

    public ShipmentItem costOfPointsGranted(Currency costOfPointsGranted) {
        this.costOfPointsGranted = costOfPointsGranted;
        return this;
    }

    @ApiModelProperty(value="The cost of Amazon Points granted for a shipment item.")
    public Currency getCostOfPointsGranted() {
        return this.costOfPointsGranted;
    }

    public void setCostOfPointsGranted(Currency costOfPointsGranted) {
        this.costOfPointsGranted = costOfPointsGranted;
    }

    public ShipmentItem costOfPointsReturned(Currency costOfPointsReturned) {
        this.costOfPointsReturned = costOfPointsReturned;
        return this;
    }

    @ApiModelProperty(value="The cost of Amazon Points returned for a shipment item. This value is only returned for refunds, guarantee claims, and chargeback events.")
    public Currency getCostOfPointsReturned() {
        return this.costOfPointsReturned;
    }

    public void setCostOfPointsReturned(Currency costOfPointsReturned) {
        this.costOfPointsReturned = costOfPointsReturned;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShipmentItem shipmentItem = (ShipmentItem)o;
        return Objects.equals(this.sellerSKU, shipmentItem.sellerSKU) && Objects.equals(this.orderItemId, shipmentItem.orderItemId) && Objects.equals(this.orderAdjustmentItemId, shipmentItem.orderAdjustmentItemId) && Objects.equals(this.quantityShipped, shipmentItem.quantityShipped) && Objects.equals(this.itemChargeList, shipmentItem.itemChargeList) && Objects.equals(this.itemChargeAdjustmentList, shipmentItem.itemChargeAdjustmentList) && Objects.equals(this.itemFeeList, shipmentItem.itemFeeList) && Objects.equals(this.itemFeeAdjustmentList, shipmentItem.itemFeeAdjustmentList) && Objects.equals(this.itemTaxWithheldList, shipmentItem.itemTaxWithheldList) && Objects.equals(this.promotionList, shipmentItem.promotionList) && Objects.equals(this.promotionAdjustmentList, shipmentItem.promotionAdjustmentList) && Objects.equals(this.costOfPointsGranted, shipmentItem.costOfPointsGranted) && Objects.equals(this.costOfPointsReturned, shipmentItem.costOfPointsReturned);
    }

    public int hashCode() {
        return Objects.hash(this.sellerSKU, this.orderItemId, this.orderAdjustmentItemId, this.quantityShipped, this.itemChargeList, this.itemChargeAdjustmentList, this.itemFeeList, this.itemFeeAdjustmentList, this.itemTaxWithheldList, this.promotionList, this.promotionAdjustmentList, this.costOfPointsGranted, this.costOfPointsReturned);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShipmentItem {\n");
        sb.append("    sellerSKU: ").append(this.toIndentedString(this.sellerSKU)).append("\n");
        sb.append("    orderItemId: ").append(this.toIndentedString(this.orderItemId)).append("\n");
        sb.append("    orderAdjustmentItemId: ").append(this.toIndentedString(this.orderAdjustmentItemId)).append("\n");
        sb.append("    quantityShipped: ").append(this.toIndentedString(this.quantityShipped)).append("\n");
        sb.append("    itemChargeList: ").append(this.toIndentedString(this.itemChargeList)).append("\n");
        sb.append("    itemChargeAdjustmentList: ").append(this.toIndentedString(this.itemChargeAdjustmentList)).append("\n");
        sb.append("    itemFeeList: ").append(this.toIndentedString(this.itemFeeList)).append("\n");
        sb.append("    itemFeeAdjustmentList: ").append(this.toIndentedString(this.itemFeeAdjustmentList)).append("\n");
        sb.append("    itemTaxWithheldList: ").append(this.toIndentedString(this.itemTaxWithheldList)).append("\n");
        sb.append("    promotionList: ").append(this.toIndentedString(this.promotionList)).append("\n");
        sb.append("    promotionAdjustmentList: ").append(this.toIndentedString(this.promotionAdjustmentList)).append("\n");
        sb.append("    costOfPointsGranted: ").append(this.toIndentedString(this.costOfPointsGranted)).append("\n");
        sb.append("    costOfPointsReturned: ").append(this.toIndentedString(this.costOfPointsReturned)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

