/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.finances;

import com.amazon.spapi.model.finances.ChargeComponentList;
import com.amazon.spapi.model.finances.DirectPaymentList;
import com.amazon.spapi.model.finances.FeeComponentList;
import com.amazon.spapi.model.finances.ShipmentItemList;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A shipment, refund, guarantee claim, or chargeback.")
public class ShipmentEvent {
    @SerializedName(value="AmazonOrderId")
    private String amazonOrderId = null;
    @SerializedName(value="SellerOrderId")
    private String sellerOrderId = null;
    @SerializedName(value="MarketplaceName")
    private String marketplaceName = null;
    @SerializedName(value="OrderChargeList")
    private ChargeComponentList orderChargeList = null;
    @SerializedName(value="OrderChargeAdjustmentList")
    private ChargeComponentList orderChargeAdjustmentList = null;
    @SerializedName(value="ShipmentFeeList")
    private FeeComponentList shipmentFeeList = null;
    @SerializedName(value="ShipmentFeeAdjustmentList")
    private FeeComponentList shipmentFeeAdjustmentList = null;
    @SerializedName(value="OrderFeeList")
    private FeeComponentList orderFeeList = null;
    @SerializedName(value="OrderFeeAdjustmentList")
    private FeeComponentList orderFeeAdjustmentList = null;
    @SerializedName(value="DirectPaymentList")
    private DirectPaymentList directPaymentList = null;
    @SerializedName(value="PostedDate")
    private String postedDate = null;
    @SerializedName(value="ShipmentItemList")
    private ShipmentItemList shipmentItemList = null;
    @SerializedName(value="ShipmentItemAdjustmentList")
    private ShipmentItemList shipmentItemAdjustmentList = null;

    public ShipmentEvent amazonOrderId(String amazonOrderId) {
        this.amazonOrderId = amazonOrderId;
        return this;
    }

    @ApiModelProperty(value="An Amazon-defined identifier for an order.")
    public String getAmazonOrderId() {
        return this.amazonOrderId;
    }

    public void setAmazonOrderId(String amazonOrderId) {
        this.amazonOrderId = amazonOrderId;
    }

    public ShipmentEvent sellerOrderId(String sellerOrderId) {
        this.sellerOrderId = sellerOrderId;
        return this;
    }

    @ApiModelProperty(value="A seller-defined identifier for an order.")
    public String getSellerOrderId() {
        return this.sellerOrderId;
    }

    public void setSellerOrderId(String sellerOrderId) {
        this.sellerOrderId = sellerOrderId;
    }

    public ShipmentEvent marketplaceName(String marketplaceName) {
        this.marketplaceName = marketplaceName;
        return this;
    }

    @ApiModelProperty(value="The name of the marketplace where the event occurred.")
    public String getMarketplaceName() {
        return this.marketplaceName;
    }

    public void setMarketplaceName(String marketplaceName) {
        this.marketplaceName = marketplaceName;
    }

    public ShipmentEvent orderChargeList(ChargeComponentList orderChargeList) {
        this.orderChargeList = orderChargeList;
        return this;
    }

    @ApiModelProperty(value="A list of order-level charges. These charges are applicable to Multi-Channel Fulfillment COD orders.")
    public ChargeComponentList getOrderChargeList() {
        return this.orderChargeList;
    }

    public void setOrderChargeList(ChargeComponentList orderChargeList) {
        this.orderChargeList = orderChargeList;
    }

    public ShipmentEvent orderChargeAdjustmentList(ChargeComponentList orderChargeAdjustmentList) {
        this.orderChargeAdjustmentList = orderChargeAdjustmentList;
        return this;
    }

    @ApiModelProperty(value="A list of order-level charge adjustments. These adjustments are applicable to Multi-Channel Fulfillment COD orders.")
    public ChargeComponentList getOrderChargeAdjustmentList() {
        return this.orderChargeAdjustmentList;
    }

    public void setOrderChargeAdjustmentList(ChargeComponentList orderChargeAdjustmentList) {
        this.orderChargeAdjustmentList = orderChargeAdjustmentList;
    }

    public ShipmentEvent shipmentFeeList(FeeComponentList shipmentFeeList) {
        this.shipmentFeeList = shipmentFeeList;
        return this;
    }

    @ApiModelProperty(value="A list of shipment-level fees.")
    public FeeComponentList getShipmentFeeList() {
        return this.shipmentFeeList;
    }

    public void setShipmentFeeList(FeeComponentList shipmentFeeList) {
        this.shipmentFeeList = shipmentFeeList;
    }

    public ShipmentEvent shipmentFeeAdjustmentList(FeeComponentList shipmentFeeAdjustmentList) {
        this.shipmentFeeAdjustmentList = shipmentFeeAdjustmentList;
        return this;
    }

    @ApiModelProperty(value="A list of shipment-level fee adjustments.")
    public FeeComponentList getShipmentFeeAdjustmentList() {
        return this.shipmentFeeAdjustmentList;
    }

    public void setShipmentFeeAdjustmentList(FeeComponentList shipmentFeeAdjustmentList) {
        this.shipmentFeeAdjustmentList = shipmentFeeAdjustmentList;
    }

    public ShipmentEvent orderFeeList(FeeComponentList orderFeeList) {
        this.orderFeeList = orderFeeList;
        return this;
    }

    @ApiModelProperty(value="A list of order-level fees. These charges are applicable to Multi-Channel Fulfillment orders.")
    public FeeComponentList getOrderFeeList() {
        return this.orderFeeList;
    }

    public void setOrderFeeList(FeeComponentList orderFeeList) {
        this.orderFeeList = orderFeeList;
    }

    public ShipmentEvent orderFeeAdjustmentList(FeeComponentList orderFeeAdjustmentList) {
        this.orderFeeAdjustmentList = orderFeeAdjustmentList;
        return this;
    }

    @ApiModelProperty(value="A list of order-level fee adjustments. These adjustments are applicable to Multi-Channel Fulfillment orders.")
    public FeeComponentList getOrderFeeAdjustmentList() {
        return this.orderFeeAdjustmentList;
    }

    public void setOrderFeeAdjustmentList(FeeComponentList orderFeeAdjustmentList) {
        this.orderFeeAdjustmentList = orderFeeAdjustmentList;
    }

    public ShipmentEvent directPaymentList(DirectPaymentList directPaymentList) {
        this.directPaymentList = directPaymentList;
        return this;
    }

    @ApiModelProperty(value="A list of transactions where buyers pay Amazon through one of the credit cards offered by Amazon or where buyers pay a seller directly through COD.")
    public DirectPaymentList getDirectPaymentList() {
        return this.directPaymentList;
    }

    public void setDirectPaymentList(DirectPaymentList directPaymentList) {
        this.directPaymentList = directPaymentList;
    }

    public ShipmentEvent postedDate(String postedDate) {
        this.postedDate = postedDate;
        return this;
    }

    @ApiModelProperty(value="The date and time when the financial event was posted.")
    public String getPostedDate() {
        return this.postedDate;
    }

    public void setPostedDate(String postedDate) {
        this.postedDate = postedDate;
    }

    public ShipmentEvent shipmentItemList(ShipmentItemList shipmentItemList) {
        this.shipmentItemList = shipmentItemList;
        return this;
    }

    @ApiModelProperty(value="")
    public ShipmentItemList getShipmentItemList() {
        return this.shipmentItemList;
    }

    public void setShipmentItemList(ShipmentItemList shipmentItemList) {
        this.shipmentItemList = shipmentItemList;
    }

    public ShipmentEvent shipmentItemAdjustmentList(ShipmentItemList shipmentItemAdjustmentList) {
        this.shipmentItemAdjustmentList = shipmentItemAdjustmentList;
        return this;
    }

    @ApiModelProperty(value="A list of shipment item adjustments.")
    public ShipmentItemList getShipmentItemAdjustmentList() {
        return this.shipmentItemAdjustmentList;
    }

    public void setShipmentItemAdjustmentList(ShipmentItemList shipmentItemAdjustmentList) {
        this.shipmentItemAdjustmentList = shipmentItemAdjustmentList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShipmentEvent shipmentEvent = (ShipmentEvent)o;
        return Objects.equals(this.amazonOrderId, shipmentEvent.amazonOrderId) && Objects.equals(this.sellerOrderId, shipmentEvent.sellerOrderId) && Objects.equals(this.marketplaceName, shipmentEvent.marketplaceName) && Objects.equals(this.orderChargeList, shipmentEvent.orderChargeList) && Objects.equals(this.orderChargeAdjustmentList, shipmentEvent.orderChargeAdjustmentList) && Objects.equals(this.shipmentFeeList, shipmentEvent.shipmentFeeList) && Objects.equals(this.shipmentFeeAdjustmentList, shipmentEvent.shipmentFeeAdjustmentList) && Objects.equals(this.orderFeeList, shipmentEvent.orderFeeList) && Objects.equals(this.orderFeeAdjustmentList, shipmentEvent.orderFeeAdjustmentList) && Objects.equals(this.directPaymentList, shipmentEvent.directPaymentList) && Objects.equals(this.postedDate, shipmentEvent.postedDate) && Objects.equals(this.shipmentItemList, shipmentEvent.shipmentItemList) && Objects.equals(this.shipmentItemAdjustmentList, shipmentEvent.shipmentItemAdjustmentList);
    }

    public int hashCode() {
        return Objects.hash(this.amazonOrderId, this.sellerOrderId, this.marketplaceName, this.orderChargeList, this.orderChargeAdjustmentList, this.shipmentFeeList, this.shipmentFeeAdjustmentList, this.orderFeeList, this.orderFeeAdjustmentList, this.directPaymentList, this.postedDate, this.shipmentItemList, this.shipmentItemAdjustmentList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShipmentEvent {\n");
        sb.append("    amazonOrderId: ").append(this.toIndentedString(this.amazonOrderId)).append("\n");
        sb.append("    sellerOrderId: ").append(this.toIndentedString(this.sellerOrderId)).append("\n");
        sb.append("    marketplaceName: ").append(this.toIndentedString(this.marketplaceName)).append("\n");
        sb.append("    orderChargeList: ").append(this.toIndentedString(this.orderChargeList)).append("\n");
        sb.append("    orderChargeAdjustmentList: ").append(this.toIndentedString(this.orderChargeAdjustmentList)).append("\n");
        sb.append("    shipmentFeeList: ").append(this.toIndentedString(this.shipmentFeeList)).append("\n");
        sb.append("    shipmentFeeAdjustmentList: ").append(this.toIndentedString(this.shipmentFeeAdjustmentList)).append("\n");
        sb.append("    orderFeeList: ").append(this.toIndentedString(this.orderFeeList)).append("\n");
        sb.append("    orderFeeAdjustmentList: ").append(this.toIndentedString(this.orderFeeAdjustmentList)).append("\n");
        sb.append("    directPaymentList: ").append(this.toIndentedString(this.directPaymentList)).append("\n");
        sb.append("    postedDate: ").append(this.toIndentedString(this.postedDate)).append("\n");
        sb.append("    shipmentItemList: ").append(this.toIndentedString(this.shipmentItemList)).append("\n");
        sb.append("    shipmentItemAdjustmentList: ").append(this.toIndentedString(this.shipmentItemAdjustmentList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

