/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.finances;

import com.amazon.spapi.model.finances.ChargeComponent;
import com.amazon.spapi.model.finances.Currency;
import com.amazon.spapi.model.finances.FeeComponent;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A fee payment event for the Early Reviewer Program.")
public class SellerReviewEnrollmentPaymentEvent {
    @SerializedName(value="PostedDate")
    private String postedDate = null;
    @SerializedName(value="EnrollmentId")
    private String enrollmentId = null;
    @SerializedName(value="ParentASIN")
    private String parentASIN = null;
    @SerializedName(value="FeeComponent")
    private FeeComponent feeComponent = null;
    @SerializedName(value="ChargeComponent")
    private ChargeComponent chargeComponent = null;
    @SerializedName(value="TotalAmount")
    private Currency totalAmount = null;

    public SellerReviewEnrollmentPaymentEvent postedDate(String postedDate) {
        this.postedDate = postedDate;
        return this;
    }

    @ApiModelProperty(value="The date and time when the financial event was posted.")
    public String getPostedDate() {
        return this.postedDate;
    }

    public void setPostedDate(String postedDate) {
        this.postedDate = postedDate;
    }

    public SellerReviewEnrollmentPaymentEvent enrollmentId(String enrollmentId) {
        this.enrollmentId = enrollmentId;
        return this;
    }

    @ApiModelProperty(value="An enrollment identifier.")
    public String getEnrollmentId() {
        return this.enrollmentId;
    }

    public void setEnrollmentId(String enrollmentId) {
        this.enrollmentId = enrollmentId;
    }

    public SellerReviewEnrollmentPaymentEvent parentASIN(String parentASIN) {
        this.parentASIN = parentASIN;
        return this;
    }

    @ApiModelProperty(value="The Amazon Standard Identification Number (ASIN) of the item that was enrolled in the Early Reviewer Program.")
    public String getParentASIN() {
        return this.parentASIN;
    }

    public void setParentASIN(String parentASIN) {
        this.parentASIN = parentASIN;
    }

    public SellerReviewEnrollmentPaymentEvent feeComponent(FeeComponent feeComponent) {
        this.feeComponent = feeComponent;
        return this;
    }

    @ApiModelProperty(value="")
    public FeeComponent getFeeComponent() {
        return this.feeComponent;
    }

    public void setFeeComponent(FeeComponent feeComponent) {
        this.feeComponent = feeComponent;
    }

    public SellerReviewEnrollmentPaymentEvent chargeComponent(ChargeComponent chargeComponent) {
        this.chargeComponent = chargeComponent;
        return this;
    }

    @ApiModelProperty(value="")
    public ChargeComponent getChargeComponent() {
        return this.chargeComponent;
    }

    public void setChargeComponent(ChargeComponent chargeComponent) {
        this.chargeComponent = chargeComponent;
    }

    public SellerReviewEnrollmentPaymentEvent totalAmount(Currency totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    @ApiModelProperty(value="The FeeComponent value plus the ChargeComponent value.")
    public Currency getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(Currency totalAmount) {
        this.totalAmount = totalAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SellerReviewEnrollmentPaymentEvent sellerReviewEnrollmentPaymentEvent = (SellerReviewEnrollmentPaymentEvent)o;
        return Objects.equals(this.postedDate, sellerReviewEnrollmentPaymentEvent.postedDate) && Objects.equals(this.enrollmentId, sellerReviewEnrollmentPaymentEvent.enrollmentId) && Objects.equals(this.parentASIN, sellerReviewEnrollmentPaymentEvent.parentASIN) && Objects.equals(this.feeComponent, sellerReviewEnrollmentPaymentEvent.feeComponent) && Objects.equals(this.chargeComponent, sellerReviewEnrollmentPaymentEvent.chargeComponent) && Objects.equals(this.totalAmount, sellerReviewEnrollmentPaymentEvent.totalAmount);
    }

    public int hashCode() {
        return Objects.hash(this.postedDate, this.enrollmentId, this.parentASIN, this.feeComponent, this.chargeComponent, this.totalAmount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SellerReviewEnrollmentPaymentEvent {\n");
        sb.append("    postedDate: ").append(this.toIndentedString(this.postedDate)).append("\n");
        sb.append("    enrollmentId: ").append(this.toIndentedString(this.enrollmentId)).append("\n");
        sb.append("    parentASIN: ").append(this.toIndentedString(this.parentASIN)).append("\n");
        sb.append("    feeComponent: ").append(this.toIndentedString(this.feeComponent)).append("\n");
        sb.append("    chargeComponent: ").append(this.toIndentedString(this.chargeComponent)).append("\n");
        sb.append("    totalAmount: ").append(this.toIndentedString(this.totalAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

