/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.finances;

import com.amazon.spapi.model.finances.Currency;
import com.amazon.spapi.model.finances.SAFETReimbursementItemList;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A SAFE-T claim reimbursement on the seller's account.")
public class SAFETReimbursementEvent {
    @SerializedName(value="PostedDate")
    private String postedDate = null;
    @SerializedName(value="SAFETClaimId")
    private String saFETClaimId = null;
    @SerializedName(value="ReimbursedAmount")
    private Currency reimbursedAmount = null;
    @SerializedName(value="ReasonCode")
    private String reasonCode = null;
    @SerializedName(value="SAFETReimbursementItemList")
    private SAFETReimbursementItemList saFETReimbursementItemList = null;

    public SAFETReimbursementEvent postedDate(String postedDate) {
        this.postedDate = postedDate;
        return this;
    }

    @ApiModelProperty(value="The date and time when the financial event was posted.")
    public String getPostedDate() {
        return this.postedDate;
    }

    public void setPostedDate(String postedDate) {
        this.postedDate = postedDate;
    }

    public SAFETReimbursementEvent saFETClaimId(String saFETClaimId) {
        this.saFETClaimId = saFETClaimId;
        return this;
    }

    @ApiModelProperty(value="A SAFE-T claim identifier.")
    public String getSaFETClaimId() {
        return this.saFETClaimId;
    }

    public void setSaFETClaimId(String saFETClaimId) {
        this.saFETClaimId = saFETClaimId;
    }

    public SAFETReimbursementEvent reimbursedAmount(Currency reimbursedAmount) {
        this.reimbursedAmount = reimbursedAmount;
        return this;
    }

    @ApiModelProperty(value="The amount of the reimbursement.")
    public Currency getReimbursedAmount() {
        return this.reimbursedAmount;
    }

    public void setReimbursedAmount(Currency reimbursedAmount) {
        this.reimbursedAmount = reimbursedAmount;
    }

    public SAFETReimbursementEvent reasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    @ApiModelProperty(value="Indicates why the seller was reimbursed.")
    public String getReasonCode() {
        return this.reasonCode;
    }

    public void setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
    }

    public SAFETReimbursementEvent saFETReimbursementItemList(SAFETReimbursementItemList saFETReimbursementItemList) {
        this.saFETReimbursementItemList = saFETReimbursementItemList;
        return this;
    }

    @ApiModelProperty(value="")
    public SAFETReimbursementItemList getSaFETReimbursementItemList() {
        return this.saFETReimbursementItemList;
    }

    public void setSaFETReimbursementItemList(SAFETReimbursementItemList saFETReimbursementItemList) {
        this.saFETReimbursementItemList = saFETReimbursementItemList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SAFETReimbursementEvent saFETReimbursementEvent = (SAFETReimbursementEvent)o;
        return Objects.equals(this.postedDate, saFETReimbursementEvent.postedDate) && Objects.equals(this.saFETClaimId, saFETReimbursementEvent.saFETClaimId) && Objects.equals(this.reimbursedAmount, saFETReimbursementEvent.reimbursedAmount) && Objects.equals(this.reasonCode, saFETReimbursementEvent.reasonCode) && Objects.equals(this.saFETReimbursementItemList, saFETReimbursementEvent.saFETReimbursementItemList);
    }

    public int hashCode() {
        return Objects.hash(this.postedDate, this.saFETClaimId, this.reimbursedAmount, this.reasonCode, this.saFETReimbursementItemList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SAFETReimbursementEvent {\n");
        sb.append("    postedDate: ").append(this.toIndentedString(this.postedDate)).append("\n");
        sb.append("    saFETClaimId: ").append(this.toIndentedString(this.saFETClaimId)).append("\n");
        sb.append("    reimbursedAmount: ").append(this.toIndentedString(this.reimbursedAmount)).append("\n");
        sb.append("    reasonCode: ").append(this.toIndentedString(this.reasonCode)).append("\n");
        sb.append("    saFETReimbursementItemList: ").append(this.toIndentedString(this.saFETReimbursementItemList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

