/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.finances;

import com.amazon.spapi.model.finances.Currency;
import com.amazon.spapi.model.finances.TaxWithheldComponentList;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A retrocharge or retrocharge reversal.")
public class RetrochargeEvent {
    @SerializedName(value="RetrochargeEventType")
    private String retrochargeEventType = null;
    @SerializedName(value="AmazonOrderId")
    private String amazonOrderId = null;
    @SerializedName(value="PostedDate")
    private String postedDate = null;
    @SerializedName(value="BaseTax")
    private Currency baseTax = null;
    @SerializedName(value="ShippingTax")
    private Currency shippingTax = null;
    @SerializedName(value="MarketplaceName")
    private String marketplaceName = null;
    @SerializedName(value="RetrochargeTaxWithheldList")
    private TaxWithheldComponentList retrochargeTaxWithheldList = null;

    public RetrochargeEvent retrochargeEventType(String retrochargeEventType) {
        this.retrochargeEventType = retrochargeEventType;
        return this;
    }

    @ApiModelProperty(value="The type of event.  Possible values:  * Retrocharge  * RetrochargeReversal")
    public String getRetrochargeEventType() {
        return this.retrochargeEventType;
    }

    public void setRetrochargeEventType(String retrochargeEventType) {
        this.retrochargeEventType = retrochargeEventType;
    }

    public RetrochargeEvent amazonOrderId(String amazonOrderId) {
        this.amazonOrderId = amazonOrderId;
        return this;
    }

    @ApiModelProperty(value="An Amazon-defined identifier for an order.")
    public String getAmazonOrderId() {
        return this.amazonOrderId;
    }

    public void setAmazonOrderId(String amazonOrderId) {
        this.amazonOrderId = amazonOrderId;
    }

    public RetrochargeEvent postedDate(String postedDate) {
        this.postedDate = postedDate;
        return this;
    }

    @ApiModelProperty(value="The date and time when the financial event was posted.")
    public String getPostedDate() {
        return this.postedDate;
    }

    public void setPostedDate(String postedDate) {
        this.postedDate = postedDate;
    }

    public RetrochargeEvent baseTax(Currency baseTax) {
        this.baseTax = baseTax;
        return this;
    }

    @ApiModelProperty(value="The base tax associated with the retrocharge event.")
    public Currency getBaseTax() {
        return this.baseTax;
    }

    public void setBaseTax(Currency baseTax) {
        this.baseTax = baseTax;
    }

    public RetrochargeEvent shippingTax(Currency shippingTax) {
        this.shippingTax = shippingTax;
        return this;
    }

    @ApiModelProperty(value="The shipping tax associated with the retrocharge event.")
    public Currency getShippingTax() {
        return this.shippingTax;
    }

    public void setShippingTax(Currency shippingTax) {
        this.shippingTax = shippingTax;
    }

    public RetrochargeEvent marketplaceName(String marketplaceName) {
        this.marketplaceName = marketplaceName;
        return this;
    }

    @ApiModelProperty(value="The name of the marketplace where the retrocharge event occurred.")
    public String getMarketplaceName() {
        return this.marketplaceName;
    }

    public void setMarketplaceName(String marketplaceName) {
        this.marketplaceName = marketplaceName;
    }

    public RetrochargeEvent retrochargeTaxWithheldList(TaxWithheldComponentList retrochargeTaxWithheldList) {
        this.retrochargeTaxWithheldList = retrochargeTaxWithheldList;
        return this;
    }

    @ApiModelProperty(value="A list of information about taxes withheld.")
    public TaxWithheldComponentList getRetrochargeTaxWithheldList() {
        return this.retrochargeTaxWithheldList;
    }

    public void setRetrochargeTaxWithheldList(TaxWithheldComponentList retrochargeTaxWithheldList) {
        this.retrochargeTaxWithheldList = retrochargeTaxWithheldList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetrochargeEvent retrochargeEvent = (RetrochargeEvent)o;
        return Objects.equals(this.retrochargeEventType, retrochargeEvent.retrochargeEventType) && Objects.equals(this.amazonOrderId, retrochargeEvent.amazonOrderId) && Objects.equals(this.postedDate, retrochargeEvent.postedDate) && Objects.equals(this.baseTax, retrochargeEvent.baseTax) && Objects.equals(this.shippingTax, retrochargeEvent.shippingTax) && Objects.equals(this.marketplaceName, retrochargeEvent.marketplaceName) && Objects.equals(this.retrochargeTaxWithheldList, retrochargeEvent.retrochargeTaxWithheldList);
    }

    public int hashCode() {
        return Objects.hash(this.retrochargeEventType, this.amazonOrderId, this.postedDate, this.baseTax, this.shippingTax, this.marketplaceName, this.retrochargeTaxWithheldList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RetrochargeEvent {\n");
        sb.append("    retrochargeEventType: ").append(this.toIndentedString(this.retrochargeEventType)).append("\n");
        sb.append("    amazonOrderId: ").append(this.toIndentedString(this.amazonOrderId)).append("\n");
        sb.append("    postedDate: ").append(this.toIndentedString(this.postedDate)).append("\n");
        sb.append("    baseTax: ").append(this.toIndentedString(this.baseTax)).append("\n");
        sb.append("    shippingTax: ").append(this.toIndentedString(this.shippingTax)).append("\n");
        sb.append("    marketplaceName: ").append(this.toIndentedString(this.marketplaceName)).append("\n");
        sb.append("    retrochargeTaxWithheldList: ").append(this.toIndentedString(this.retrochargeTaxWithheldList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

